/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.TemplateCacheComponent;
import org.publiccms.views.pojo.CmsPageMetadata;
import org.publiccms.views.pojo.CmsPlaceParamters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cmsPage"})
public class CmsPageAdminController
extends AbstractController {
    @Autowired
    private MetadataComponent metadataComponent;
    @Autowired
    private TemplateCacheComponent templateCacheComponent;

    @RequestMapping(value={"save"})
    public String saveMetadata(String path, @ModelAttribute CmsPlaceParamters placeParamters, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getWebTemplateFilePath(site, path);
            CmsPageMetadata oldmetadata = this.metadataComponent.getTemplateMetadata(filePath);
            oldmetadata.setExtendDataList(placeParamters.getExtendDataList());
            this.metadataComponent.updateTemplateMetadata(filePath, oldmetadata);
            this.logOperateService.save(new LogOperate(site.getId(), CmsPageAdminController.getAdminFromSession(session).getId(), "web_manager", "update.template.data", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"clearCache"})
    public String clearCache(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            this.templateCacheComponent.deleteCachedFile(SiteComponent.getFullFileName(site, path));
            this.logOperateService.save(new LogOperate(site.getId(), CmsPageAdminController.getAdminFromSession(session).getId(), "web_manager", "clear.pageCache", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }
}

