/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.template.ModelComponent;
import org.publiccms.views.pojo.CmsModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cmsModel"})
public class CmsModelAdminController
extends AbstractController {
    @Autowired
    private ModelComponent modelComponent;

    @RequestMapping(value={"save"})
    public String save(@ModelAttribute CmsModel entity, String modelId, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        this.modelComponent.clear(site.getId());
        if (CommonUtils.notEmpty(modelId)) {
            Map<String, CmsModel> modelMap = this.modelComponent.getMap(site);
            modelMap.remove(modelId);
            modelMap.put(entity.getId(), entity);
            this.modelComponent.save(site, modelMap);
            this.logOperateService.save(new LogOperate(site.getId(), CmsModelAdminController.getAdminFromSession(session).getId(), "web_manager", "update.model", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        } else {
            Map<String, CmsModel> modelMap = this.modelComponent.getMap(site);
            modelMap.put(entity.getId(), entity);
            this.modelComponent.save(site, modelMap);
            this.logOperateService.save(new LogOperate(site.getId(), CmsModelAdminController.getAdminFromSession(session).getId(), "web_manager", "save.model", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(String id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        Map<String, CmsModel> modelMap = this.modelComponent.getMap(site);
        CmsModel entity = modelMap.remove(id);
        if (null != entity) {
            List<CmsModel> modelList = this.modelComponent.getList(site, entity.getId(), null, null, null, null);
            for (CmsModel m : modelList) {
                m.setParentId(null);
                modelMap.put(m.getId(), m);
            }
            this.modelComponent.save(site, modelMap);
            this.logOperateService.save(new LogOperate(site.getId(), CmsModelAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.model", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

