/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.cms.CmsDictionary;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.cms.CmsDictionaryDataService;
import org.publiccms.logic.service.cms.CmsDictionaryService;
import org.publiccms.views.pojo.CmsDictionaryParamters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cmsDictionary"})
public class CmsDictionaryAdminController
extends AbstractController {
    private String[] ignoreProperties = new String[]{"id"};
    @Autowired
    private CmsDictionaryService service;
    @Autowired
    private CmsDictionaryDataService dataService;

    @RequestMapping(value={"save"})
    public String save(CmsDictionary entity, CmsDictionaryParamters dictionaryParamters, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            entity = this.service.update(entity.getId(), entity, this.ignoreProperties);
            this.dataService.update(entity.getId(), dictionaryParamters.getDataList());
            this.logOperateService.save(new LogOperate(site.getId(), CmsDictionaryAdminController.getAdminFromSession(session).getId(), "web_manager", "update.cmsDictionary", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        } else {
            this.service.save(entity);
            this.dataService.save(entity.getId(), dictionaryParamters.getDataList());
            this.logOperateService.save(new LogOperate(site.getId(), CmsDictionaryAdminController.getAdminFromSession(session).getId(), "web_manager", "save.cmsDictionary", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer[] ids, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(ids)) {
            this.service.delete(ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsDictionaryAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.cmsDictionary", RequestUtils.getIpAddress(request), CommonUtils.getDate(), StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }
}

