/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.HtmlUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.LanguagesUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ArrayUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.entities.cms.CmsCategoryModel;
import org.publiccms.entities.cms.CmsCategoryModelId;
import org.publiccms.entities.cms.CmsContent;
import org.publiccms.entities.cms.CmsContentAttribute;
import org.publiccms.entities.cms.CmsContentRelated;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysDept;
import org.publiccms.entities.sys.SysDeptCategoryId;
import org.publiccms.entities.sys.SysExtendField;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.component.template.ModelComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsCategoryModelService;
import org.publiccms.logic.service.cms.CmsCategoryService;
import org.publiccms.logic.service.cms.CmsContentAttributeService;
import org.publiccms.logic.service.cms.CmsContentFileService;
import org.publiccms.logic.service.cms.CmsContentRelatedService;
import org.publiccms.logic.service.cms.CmsContentService;
import org.publiccms.logic.service.cms.CmsTagService;
import org.publiccms.logic.service.sys.SysDeptCategoryService;
import org.publiccms.logic.service.sys.SysDeptService;
import org.publiccms.logic.service.sys.SysExtendFieldService;
import org.publiccms.logic.service.sys.SysExtendService;
import org.publiccms.views.pojo.CmsContentParamters;
import org.publiccms.views.pojo.CmsModel;
import org.publiccms.views.pojo.ExtendField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.support.RequestContextUtils;

@Controller
@RequestMapping(value={"cmsContent"})
public class CmsContentAdminController
extends AbstractController {
    @Autowired
    private CmsContentService service;
    @Autowired
    private SysDeptCategoryService sysDeptCategoryService;
    @Autowired
    private SysDeptService sysDeptService;
    @Autowired
    private CmsContentRelatedService cmsContentRelatedService;
    @Autowired
    private CmsTagService tagService;
    @Autowired
    private CmsContentFileService contentFileService;
    @Autowired
    private CmsCategoryModelService categoryModelService;
    @Autowired
    private ModelComponent modelComponent;
    @Autowired
    private CmsCategoryService categoryService;
    @Autowired
    private CmsContentAttributeService attributeService;
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private SysExtendService extendService;
    @Autowired
    private SysExtendFieldService extendFieldService;
    private String[] ignoreProperties = new String[]{"siteId", "userId", "categoryId", "tagIds", "sort", "createDate", "clicks", "comments", "scores", "childs", "checkUserId"};
    private String[] ignorePropertiesWithUrl = (String[])ArrayUtils.addAll((Object[])this.ignoreProperties, (Object[])new String[]{"url"});

    @RequestMapping(value={"save"})
    public String save(CmsContent entity, CmsContentAttribute attribute, @ModelAttribute CmsContentParamters contentParamters, Boolean draft, Boolean checked, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysUser user = CmsContentAdminController.getAdminFromSession(session);
        SysDept dept = (SysDept)this.sysDeptService.getEntity(user.getDeptId());
        if (ControllerUtils.verifyNotEmpty("deptId", user.getDeptId(), (Map<String, Object>)model) && ControllerUtils.verifyNotEmpty("deptId", dept, (Map<String, Object>)model) && ControllerUtils.verifyCustom("noright", !dept.isOwnsAllCategory() && null == this.sysDeptCategoryService.getEntity(new SysDeptCategoryId(user.getDeptId(), entity.getCategoryId())), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        CmsCategoryModel categoryModel = (CmsCategoryModel)this.categoryModelService.getEntity(new CmsCategoryModelId(entity.getCategoryId(), entity.getModelId()));
        if (ControllerUtils.verifyNotEmpty("categoryModel", categoryModel, (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        CmsCategory category = (CmsCategory)this.categoryService.getEntity(Integer.valueOf(entity.getCategoryId()));
        if (null != category && site.getId().intValue() != category.getSiteId()) {
            category = null;
        }
        CmsModel cmsModel = this.modelComponent.getMap(site).get(entity.getModelId());
        if (ControllerUtils.verifyNotEmpty("category", category, (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("model", cmsModel, (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        entity.setHasFiles(cmsModel.isHasFiles());
        entity.setHasImages(cmsModel.isHasImages());
        entity.setOnlyUrl(cmsModel.isOnlyUrl());
        if ((null == checked || !checked.booleanValue()) && null != draft && draft.booleanValue()) {
            entity.setStatus(0);
        } else {
            entity.setStatus(2);
        }
        Date now = CommonUtils.getDate();
        if (CommonUtils.empty(entity.getPublishDate())) {
            entity.setPublishDate(now);
        }
        if (null != entity.getId()) {
            CmsContent oldEntity = (CmsContent)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update(entity.getId(), entity, entity.isOnlyUrl() ? this.ignoreProperties : this.ignorePropertiesWithUrl))) {
                this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web_manager", "update.content", RequestUtils.getIpAddress(request), now, JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            entity.setUserId(user.getId());
            this.service.save(entity);
            if (CommonUtils.notEmpty(entity.getParentId())) {
                this.service.updateChilds(entity.getParentId(), 1);
            } else {
                this.categoryService.updateContents(Integer.valueOf(entity.getCategoryId()), 1);
            }
            this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web_manager", "save.content", RequestUtils.getIpAddress(request), now, JsonUtils.getString(entity)));
        }
        Object[] tagIds = this.tagService.update(site.getId(), contentParamters.getTags());
        this.service.updateTagIds(entity.getId(), StringUtils.arrayToDelimitedString((Object[])tagIds, (String)" "));
        if (entity.isHasImages() || entity.isHasFiles()) {
            this.contentFileService.update(entity.getId(), user.getId(), entity.isHasFiles() ? contentParamters.getFiles() : null, entity.isHasImages() ? contentParamters.getImages() : null);
        }
        if (null != attribute.getText()) {
            attribute.setWordCount(HtmlUtils.removeHtmlTag(attribute.getText()).length());
        }
        List<ExtendField> modelExtendList = cmsModel.getExtendList();
        Map<String, String> map = ExtendUtils.getExtentDataMap(contentParamters.getModelExtendDataList(), modelExtendList);
        if (null != category && null != this.extendService.getEntity(category.getExtendId())) {
            List<SysExtendField> categoryExtendList = this.extendFieldService.getList(category.getExtendId());
            Map<String, String> categoryMap = ExtendUtils.getSysExtentDataMap(contentParamters.getCategoryExtendDataList(), categoryExtendList);
            if (CommonUtils.notEmpty(map)) {
                map.putAll(categoryMap);
            } else {
                map = categoryMap;
            }
        }
        if (CommonUtils.notEmpty(map)) {
            attribute.setData(ExtendUtils.getExtendString(map));
        } else {
            attribute.setData(null);
        }
        this.attributeService.updateAttribute(entity.getId(), attribute);
        this.cmsContentRelatedService.update(entity.getId(), user.getId(), contentParamters.getContentRelateds());
        this.templateComponent.createContentFile(site, entity, category, categoryModel);
        if (null != checked && checked.booleanValue()) {
            this.service.check(site.getId(), user.getId(), new Long[]{entity.getId()});
            if (CommonUtils.notEmpty(entity.getParentId())) {
                this.publish(new Long[]{entity.getParentId()}, request, session, model);
            }
            this.templateComponent.createCategoryFile(site, category, null, null);
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"check"})
    public String check(Long[] ids, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(ids)) {
            SysSite site = this.getSite(request);
            Long userId = CmsContentAdminController.getAdminFromSession(session).getId();
            List<CmsContent> entityList = this.service.check(site.getId(), userId, ids);
            HashSet<Integer> categoryIdSet = new HashSet<Integer>();
            for (CmsContent entity : entityList) {
                if (null == entity || site.getId().intValue() != entity.getSiteId()) continue;
                if (CommonUtils.notEmpty(entity.getParentId())) {
                    this.publish(new Long[]{entity.getParentId()}, request, session, model);
                }
                this.publish(new Long[]{entity.getId()}, request, session, model);
                categoryIdSet.add(entity.getCategoryId());
            }
            for (CmsCategory category : this.categoryService.getEntitys(categoryIdSet.toArray(new Integer[categoryIdSet.size()]))) {
                this.templateComponent.createCategoryFile(site, category, null, null);
            }
            this.logOperateService.save(new LogOperate(site.getId(), userId, "web_manager", "check.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"refresh"})
    public String refresh(Long[] ids, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(ids)) {
            SysSite site = this.getSite(request);
            this.service.refresh(site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsContentAdminController.getAdminFromSession(session).getId(), "web_manager", "refresh.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"related"})
    public String related(CmsContentRelated entity, HttpServletRequest request, HttpSession session, ModelMap model) {
        CmsContent content = (CmsContent)this.service.getEntity(Long.valueOf(entity.getContentId()));
        CmsContent related = (CmsContent)this.service.getEntity(entity.getRelatedContentId());
        SysSite site = this.getSite(request);
        if (null != content && null != related && site.getId().intValue() == content.getSiteId() && site.getId().intValue() == related.getSiteId()) {
            if (CommonUtils.empty(entity.getTitle())) {
                entity.setTitle(entity.getTitle());
            }
            if (CommonUtils.empty(entity.getDescription())) {
                entity.setDescription(entity.getDescription());
            }
            SysUser user = CmsContentAdminController.getAdminFromSession(session);
            entity.setUserId(user.getId());
            this.cmsContentRelatedService.save(entity);
            this.publish(new Long[]{entity.getContentId()}, request, session, model);
            this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web_manager", "related.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(related)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"move"})
    public String move(Long[] ids, Integer categoryId, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        CmsCategory category = (CmsCategory)this.categoryService.getEntity(categoryId);
        if (CommonUtils.notEmpty(ids) && null != category && site.getId().intValue() == category.getSiteId()) {
            StringBuilder sb = new StringBuilder();
            for (CmsContent entity : this.service.getEntitys(ids)) {
                if (this.move(site, entity, categoryId)) continue;
                sb.append(LanguagesUtils.getMessage(CommonConstants.webApplicationContext, RequestContextUtils.getLocale((HttpServletRequest)request), "message.content.categoryModel.empty", entity.getId() + ":" + entity.getTitle(), categoryId + ":" + category.getName())).append(",");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            model.put((Object)"message", (Object)sb.toString());
            this.logOperateService.save(new LogOperate(site.getId(), CmsContentAdminController.getAdminFromSession(session).getId(), "web_manager", "move.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',') + " to " + category.getId() + ":" + category.getName()));
        }
        return "common/ajaxDone";
    }

    private boolean move(SysSite site, CmsContent entity, Integer categoryId) {
        CmsCategoryModel categoryModel;
        if (null != entity && site.getId().intValue() == entity.getSiteId() && null != (categoryModel = (CmsCategoryModel)this.categoryModelService.getEntity(new CmsCategoryModelId(categoryId, entity.getModelId())))) {
            this.categoryService.updateContents(categoryId, 1);
            this.categoryService.updateContents(Integer.valueOf(entity.getCategoryId()), -1);
            entity = this.service.updateCategoryId(entity.getSiteId(), entity.getId(), categoryId);
            this.templateComponent.createContentFile(site, entity, null, categoryModel);
            return true;
        }
        return false;
    }

    @RequestMapping(value={"sort"})
    public String sort(Long id, int sort, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(id)) {
            CmsContent entity = this.service.sort(site.getId(), id, sort);
            this.logOperateService.save(new LogOperate(site.getId(), CmsContentAdminController.getAdminFromSession(session).getId(), "web_manager", "sort.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), entity.getId() + ":" + entity.getTitle() + " to " + sort));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"publish"})
    public String publish(Long[] ids, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(ids)) {
            for (CmsContent entity : this.service.getEntitys(ids)) {
                CmsCategoryModel categoryModel = (CmsCategoryModel)this.categoryModelService.getEntity(new CmsCategoryModelId(entity.getCategoryId(), entity.getModelId()));
                if (null == categoryModel || entity.isOnlyUrl() || this.templateComponent.createContentFile(site, entity, null, categoryModel)) continue;
                ControllerUtils.verifyCustom("static", true, (Map<String, Object>)model);
                return "common/ajaxError";
            }
            this.logOperateService.save(new LogOperate(site.getId(), CmsContentAdminController.getAdminFromSession(session).getId(), "web_manager", "static.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Long[] ids, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(ids)) {
            for (CmsContent entity : this.service.getEntitys(ids)) {
                if (!entity.isDisabled() && site.getId().intValue() == entity.getSiteId()) {
                    if (CommonUtils.notEmpty(entity.getParentId())) {
                        this.service.updateChilds(entity.getParentId(), -1);
                        continue;
                    }
                    this.categoryService.updateContents(Integer.valueOf(entity.getCategoryId()), -1);
                    continue;
                }
                ArrayUtils.removeElements((Object[])ids, (Object[])new Long[]{entity.getId()});
            }
            this.service.delete(site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsContentAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"recycle"})
    public String recycle(Long[] ids, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(ids)) {
            for (CmsContent entity : this.service.getEntitys(ids)) {
                if (!entity.isDisabled() || site.getId().intValue() != entity.getSiteId()) continue;
                if (CommonUtils.notEmpty(entity.getParentId())) {
                    this.service.updateChilds(entity.getParentId(), 1);
                    continue;
                }
                this.categoryService.updateContents(Integer.valueOf(entity.getCategoryId()), 1);
            }
            this.service.recycle(site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsContentAdminController.getAdminFromSession(session).getId(), "web_manager", "recycle.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"realDelete"})
    public String realDelete(Long[] ids, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(ids)) {
            this.service.realDelete(site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsContentAdminController.getAdminFromSession(session).getId(), "web_manager", "realDelete.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }
}

