/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.cms.CmsCategoryType;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysExtend;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.cms.CmsCategoryService;
import org.publiccms.logic.service.cms.CmsCategoryTypeService;
import org.publiccms.logic.service.sys.SysExtendFieldService;
import org.publiccms.logic.service.sys.SysExtendService;
import org.publiccms.views.pojo.CmsCategoryTypeParamters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cmsCategoryType"})
public class CmsCategoryTypeAdminController
extends AbstractController {
    @Autowired
    private CmsCategoryTypeService service;
    @Autowired
    private CmsCategoryService categoryService;
    @Autowired
    private SysExtendService extendService;
    @Autowired
    private SysExtendFieldService extendFieldService;
    private String[] ignoreProperties = new String[]{"id", "siteId", "extendId"};

    @RequestMapping(value={"save"})
    public String save(CmsCategoryType entity, @ModelAttribute CmsCategoryTypeParamters categoryTypeParamters, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            CmsCategoryType oldEntity = (CmsCategoryType)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryTypeAdminController.getAdminFromSession(session).getId(), "web_manager", "update.categoryType", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            this.service.save(entity);
            this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryTypeAdminController.getAdminFromSession(session).getId(), "web_manager", "save.categoryType", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        if (null == this.extendService.getEntity(entity.getExtendId())) {
            entity = this.service.updateExtendId(entity.getId(), (Integer)this.extendService.save(new SysExtend("categoryType", entity.getId())));
        }
        this.extendFieldService.update(entity.getExtendId(), categoryTypeParamters.getCategoryExtends());
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        CmsCategoryType entity = (CmsCategoryType)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model) || ControllerUtils.verifyNotGreaterThen("category", this.categoryService.getPage(site.getId(), null, true, id, null, null, false, null, 1).getTotalCount(), 1, (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.delete(id);
            this.extendService.delete(entity.getExtendId());
            this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryTypeAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.categoryType", RequestUtils.getIpAddress(request), CommonUtils.getDate(), id.toString()));
        }
        return "common/ajaxDone";
    }
}

