/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.entities.cms.CmsCategoryAttribute;
import org.publiccms.entities.cms.CmsCategoryType;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysExtend;
import org.publiccms.entities.sys.SysExtendField;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsCategoryAttributeService;
import org.publiccms.logic.service.cms.CmsCategoryModelService;
import org.publiccms.logic.service.cms.CmsCategoryService;
import org.publiccms.logic.service.cms.CmsCategoryTypeService;
import org.publiccms.logic.service.cms.CmsContentService;
import org.publiccms.logic.service.cms.CmsTagTypeService;
import org.publiccms.logic.service.sys.SysExtendFieldService;
import org.publiccms.logic.service.sys.SysExtendService;
import org.publiccms.views.pojo.CmsCategoryModelParamters;
import org.publiccms.views.pojo.CmsCategoryParamters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cmsCategory"})
public class CmsCategoryAdminController
extends AbstractController {
    @Autowired
    private CmsCategoryService service;
    @Autowired
    private CmsTagTypeService tagTypeService;
    @Autowired
    private CmsContentService contentService;
    @Autowired
    private CmsCategoryAttributeService attributeService;
    @Autowired
    private CmsCategoryModelService categoryModelService;
    @Autowired
    private CmsCategoryTypeService categoryTypeService;
    @Autowired
    private SysExtendService extendService;
    @Autowired
    private SysExtendFieldService extendFieldService;
    @Autowired
    private TemplateComponent templateComponent;
    private String[] ignoreProperties = new String[]{"siteId", "childIds", "tagTypeIds", "url", "disabled", "extendId", "contents", "typeId"};

    @RequestMapping(value={"save"})
    public String save(CmsCategory entity, CmsCategoryAttribute attribute, @ModelAttribute CmsCategoryParamters categoryParamters, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            CmsCategory oldEntity = (CmsCategory)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                if (null != oldEntity.getParentId() && !oldEntity.getParentId().equals(entity.getParentId())) {
                    this.service.generateChildIds(site.getId(), oldEntity.getParentId());
                    this.service.generateChildIds(site.getId(), entity.getParentId());
                } else if (null != entity.getParentId() && null == oldEntity.getParentId()) {
                    this.service.generateChildIds(site.getId(), entity.getParentId());
                }
                this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryAdminController.getAdminFromSession(session).getId(), "web_manager", "update.category", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            if (entity.isOnlyUrl()) {
                entity.setUrl(entity.getPath());
            }
            entity.setSiteId(site.getId());
            this.service.save(entity);
            this.service.addChildIds(entity.getParentId(), entity.getId());
            this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryAdminController.getAdminFromSession(session).getId(), "web_manager", "save.category", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        if (null == this.extendService.getEntity(entity.getExtendId())) {
            entity = this.service.updateExtendId(entity.getId(), (Integer)this.extendService.save(new SysExtend("category", entity.getId())));
        }
        Object[] tagTypeIds = this.tagTypeService.update(site.getId(), categoryParamters.getTagTypes());
        this.service.updateTagTypeIds(entity.getId(), StringUtils.arrayToCommaDelimitedString((Object[])tagTypeIds));
        List<CmsCategoryModelParamters> categoryModelList = categoryParamters.getCategoryModelList();
        if (CommonUtils.notEmpty(categoryModelList)) {
            for (CmsCategoryModelParamters cmsCategoryModelParamters : categoryModelList) {
                if (null == cmsCategoryModelParamters.getCategoryModel()) continue;
                cmsCategoryModelParamters.getCategoryModel().getId().setCategoryId(entity.getId());
                if (cmsCategoryModelParamters.isUse()) {
                    this.categoryModelService.updateCategoryModel(cmsCategoryModelParamters.getCategoryModel());
                    continue;
                }
                this.categoryModelService.delete(cmsCategoryModelParamters.getCategoryModel().getId());
            }
        }
        this.extendFieldService.update(entity.getExtendId(), categoryParamters.getContentExtends());
        CmsCategoryType categoryType = (CmsCategoryType)this.categoryTypeService.getEntity(entity.getTypeId());
        if (null != categoryType && CommonUtils.notEmpty(categoryType.getExtendId())) {
            List<SysExtendField> categoryTypeExtendList = this.extendFieldService.getList(categoryType.getExtendId());
            Map<String, String> map = ExtendUtils.getSysExtentDataMap(categoryParamters.getExtendDataList(), categoryTypeExtendList);
            attribute.setData(ExtendUtils.getExtendString(map));
        } else {
            attribute.setData(null);
        }
        this.attributeService.updateAttribute(entity.getId(), attribute);
        try {
            this.publish(site, entity.getId(), null);
        }
        catch (TemplateException | IOException e) {
            ControllerUtils.verifyCustom("static", true, (Map<String, Object>)model);
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"move"})
    public String move(Integer[] ids, Integer parentId, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        CmsCategory parent = (CmsCategory)this.service.getEntity(parentId);
        if (CommonUtils.notEmpty(ids) && (null == parent || null != parent && site.getId().intValue() == parent.getSiteId())) {
            for (Integer id : ids) {
                this.move(site, id, parentId);
            }
            this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryAdminController.getAdminFromSession(session).getId(), "web_manager", "move.category", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',') + " to " + parentId));
        }
        return "common/ajaxDone";
    }

    private void move(SysSite site, Integer id, Integer parentId) {
        CmsCategory entity = (CmsCategory)this.service.getEntity(id);
        if (null != entity && site.getId().intValue() == entity.getSiteId()) {
            this.service.updateParentId(site.getId(), id, parentId);
            this.service.generateChildIds(site.getId(), entity.getParentId());
            if (null != parentId) {
                this.service.generateChildIds(site.getId(), parentId);
            }
        }
    }

    @RequestMapping(value={"publish"})
    public String publish(Integer[] ids, Integer max, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(ids)) {
            try {
                for (Integer id : ids) {
                    this.publish(site, id, max);
                }
            }
            catch (TemplateException | IOException e) {
                ControllerUtils.verifyCustom("static", true, (Map<String, Object>)model);
                this.log.error((Object)e.getMessage());
                return "common/ajaxError";
            }
            this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryAdminController.getAdminFromSession(session).getId(), "web_manager", "static.category", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',') + ",pageSize:" + (CommonUtils.empty(max) ? 1 : max)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"changeType"})
    public String changeType(Integer id, Integer typeId, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(id)) {
            this.service.changeType(id, typeId);
            this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryAdminController.getAdminFromSession(session).getId(), "web_manager", "changeType.category", RequestUtils.getIpAddress(request), CommonUtils.getDate(), new StringBuilder(id).append(" to ").append(typeId).toString()));
        }
        return "common/ajaxDone";
    }

    private void publish(SysSite site, Integer id, Integer max) throws IOException, TemplateException {
        CmsCategory entity = (CmsCategory)this.service.getEntity(id);
        if (null != site && null != entity && site.getId().intValue() == entity.getSiteId()) {
            this.templateComponent.createCategoryFile(site, entity, null, max);
        }
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer[] ids, HttpServletRequest request, HttpSession session) {
        if (CommonUtils.notEmpty(ids)) {
            SysSite site = this.getSite(request);
            this.service.delete(site.getId(), ids);
            this.contentService.deleteByCategoryIds(site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsCategoryAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.category", RequestUtils.getIpAddress(request), CommonUtils.getDate(), org.apache.commons.lang3.StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }
}

