/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.VerificationUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.log.LogLogin;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.component.cache.CacheComponent;
import org.publiccms.logic.service.log.LogLoginService;
import org.publiccms.logic.service.sys.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LoginAdminController
extends AbstractController {
    @Autowired
    private SysUserService service;
    @Autowired
    private LogLoginService logLoginService;
    @Autowired
    private CacheComponent cacheComponent;

    @RequestMapping(value={"login"}, method={RequestMethod.POST})
    public String login(String username, String password, String returnUrl, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        username = StringUtils.trim((String)username);
        password = StringUtils.trim((String)password);
        if (ControllerUtils.verifyNotEmpty("username", username, (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("password", password, (Map<String, Object>)model)) {
            model.addAttribute("username", (Object)username);
            model.addAttribute("returnUrl", (Object)returnUrl);
            return "login";
        }
        String ip = RequestUtils.getIpAddress(request);
        SysUser user = this.service.findByName(site.getId(), username);
        if (ControllerUtils.verifyNotExist("username", user, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("password", VerificationUtils.encode(password), user.getPassword(), (Map<String, Object>)model) || this.verifyNotAdmin(user, model) || this.verifyNotEnablie(user, model)) {
            model.addAttribute("username", (Object)username);
            model.addAttribute("returnUrl", (Object)returnUrl);
            Long userId = null;
            if (null != user) {
                userId = user.getId();
            }
            this.logLoginService.save(new LogLogin(site.getId(), username, userId, ip, "web_manager", false, CommonUtils.getDate(), password));
            return "login";
        }
        LoginAdminController.setAdminToSession(session, user);
        this.service.updateLoginStatus(user.getId(), RequestUtils.getIpAddress(request));
        this.logLoginService.save(new LogLogin(site.getId(), username, user.getId(), ip, "web_manager", true, CommonUtils.getDate(), null));
        if (CommonUtils.notEmpty(returnUrl)) {
            return "redirect:" + returnUrl;
        }
        return "redirect:" + CommonConstants.getDefaultPage();
    }

    @RequestMapping(value={"loginDialog"}, method={RequestMethod.POST})
    public String loginDialog(String username, String password, HttpServletRequest request, HttpSession session, ModelMap model) {
        if ("login".equals(this.login(username, password, null, request, session, model))) {
            return "common/ajaxError";
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"changePassword"}, method={RequestMethod.POST})
    public String changeMyselfPassword(String oldpassword, String password, String repassword, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysUser user = (SysUser)this.service.getEntity(LoginAdminController.getAdminFromSession(session).getId());
        if (ControllerUtils.verifyNotEquals("siteId", site.getId(), user.getSiteId(), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        String encodedOldPassword = VerificationUtils.encode(oldpassword);
        if (ControllerUtils.verifyNotEquals("password", user.getPassword(), encodedOldPassword, (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        if (ControllerUtils.verifyNotEmpty("password", password, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("repassword", password, repassword, (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        LoginAdminController.clearAdminToSession(session);
        model.addAttribute("message", (Object)"message.needReLogin");
        this.service.updatePassword(user.getId(), VerificationUtils.encode(password));
        this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web_manager", "changepassword", RequestUtils.getIpAddress(request), CommonUtils.getDate(), encodedOldPassword));
        return "common/ajaxTimeout";
    }

    @RequestMapping(value={"logout"}, method={RequestMethod.GET})
    public String logout(HttpSession session) {
        LoginAdminController.clearAdminToSession(session);
        return "redirect:" + CommonConstants.getDefaultPage();
    }

    @RequestMapping(value={"clearCache"})
    public String clearCache() {
        this.cacheComponent.clear();
        return "common/ajaxDone";
    }

    protected boolean verifyNotAdmin(SysUser user, ModelMap model) {
        if (!user.isDisabled() && !user.isSuperuserAccess()) {
            model.addAttribute("error", (Object)"verify.user.notAdmin");
            return true;
        }
        return false;
    }

    protected boolean verifyNotEnablie(SysUser user, ModelMap model) {
        if (user.isDisabled()) {
            model.addAttribute("error", (Object)"verify.user.notEnablie");
            return true;
        }
        return false;
    }
}

