/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import com.publiccms.common.base.Base;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.publiccms.entities.sys.SysExtendField;
import org.publiccms.views.pojo.ExtendData;
import org.publiccms.views.pojo.ExtendField;

public class ExtendUtils
implements Base {
    public static Map<String, String> getSysExtentDataMap(List<ExtendData> extendDataList, List<SysExtendField> sysExtendFieldList) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CommonUtils.notEmpty(extendDataList)) {
            HashMap<String, String> extendFieldMap = new HashMap<String, String>();
            for (ExtendData extendData : extendDataList) {
                extendFieldMap.put(extendData.getName(), extendData.getValue());
            }
            for (SysExtendField sysExtendField : sysExtendFieldList) {
                String value = (String)extendFieldMap.get(sysExtendField.getId().getCode());
                if (null == value) {
                    map.put(sysExtendField.getId().getCode(), sysExtendField.getDefaultValue());
                    continue;
                }
                map.put(sysExtendField.getId().getCode(), value);
            }
        }
        return map;
    }

    public static Map<String, String> getExtentDataMap(List<ExtendData> extendDataList, List<ExtendField> extendFieldList) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CommonUtils.notEmpty(extendDataList)) {
            HashMap<String, String> extendFieldMap = new HashMap<String, String>();
            for (ExtendData extendData : extendDataList) {
                extendFieldMap.put(extendData.getName(), extendData.getValue());
            }
            for (ExtendField extendField : extendFieldList) {
                String value = (String)extendFieldMap.get(extendField.getId().getCode());
                if (null == value) {
                    map.put(extendField.getId().getCode(), extendField.getDefaultValue());
                    continue;
                }
                map.put(extendField.getId().getCode(), value);
            }
        }
        return map;
    }

    public static Map<String, String> getExtendMap(String data) {
        if (CommonUtils.notEmpty(data)) {
            try {
                return (Map)objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException | ClassCastException e) {
                return new HashMap<String, String>();
            }
        }
        return new HashMap<String, String>();
    }

    public static String getExtendString(Map<String, String> map) {
        try {
            return objectMapper.writeValueAsString(map);
        }
        catch (IOException e) {
            return null;
        }
    }
}

