/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.servlet;

import com.publiccms.common.base.Base;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.logic.component.site.SiteComponent;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.UrlPathHelper;

public class WebFileHttpRequestHandler
extends ResourceHttpRequestHandler
implements Base {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private SiteComponent siteComponent;

    public WebFileHttpRequestHandler(SiteComponent siteComponent) {
        this.siteComponent = siteComponent;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addHeader(CommonConstants.getXPowered(), CmsVersion.getVersion());
        super.handleRequest(request, response);
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        FileSystemResource resource;
        String path = this.urlPathHelper.getLookupPathForRequest(request);
        if (path.endsWith("/")) {
            path = path + CommonConstants.getDefaultPage();
        }
        if ((resource = new FileSystemResource(this.siteComponent.getWebFilePath(this.siteComponent.getSite(request.getServerName()), path))).exists() && resource.isReadable()) {
            return resource;
        }
        return null;
    }
}

