/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.servlet;

import com.publiccms.common.servlet.ErrorToNotFoundDispatcherServlet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.logic.component.site.SiteComponent;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.resource.DefaultServletHttpRequestHandler;

public class WebDispatcherServlet
extends ErrorToNotFoundDispatcherServlet {
    private SiteComponent siteComponent;
    public static final String GLOBLE_URL_PREFIX = "globle:";
    private static final int GLOBLE_URL_PREFIX_LENGTH = "globle:".length();
    private DefaultServletHttpRequestHandler installHandler;
    private static final long serialVersionUID = 1L;

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (CmsVersion.isInitialized()) {
            super.doService(request, response);
        } else {
            this.getInstallHandler().handleRequest(request, response);
        }
    }

    public WebDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    protected View resolveViewName(String viewName, Map<String, Object> model, Locale locale, HttpServletRequest request) throws Exception {
        String multiSiteViewName = viewName.startsWith("redirect:") || viewName.startsWith("redirect:") ? viewName : (viewName.startsWith(GLOBLE_URL_PREFIX) ? viewName.substring(GLOBLE_URL_PREFIX_LENGTH) : this.getSiteComponent().getViewNamePreffix(request.getServerName()) + viewName);
        return super.resolveViewName(multiSiteViewName, model, locale, request);
    }

    public SiteComponent getSiteComponent() {
        if (null == this.siteComponent) {
            this.siteComponent = (SiteComponent)this.getWebApplicationContext().getBean(SiteComponent.class);
        }
        return this.siteComponent;
    }

    public DefaultServletHttpRequestHandler getInstallHandler() {
        if (null == this.installHandler) {
            this.installHandler = new DefaultServletHttpRequestHandler();
            this.installHandler.setServletContext(this.getWebApplicationContext().getServletContext());
        }
        return this.installHandler;
    }
}

