/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.servlet;

import com.publiccms.common.base.Base;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.common.database.CmsDataSource;
import org.publiccms.common.database.CmsUpgrader;
import org.publiccms.common.tools.DatabaseUtils;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class InstallServlet
extends HttpServlet
implements Base {
    private static final long serialVersionUID = 1L;
    public static final String STEP_CHECKDATABASE = "checkDataBase";
    public static final String STEP_DATABASECONFIG = "dataBaseConfig";
    public static final String STEP_INITDATABASE = "initDatabase";
    public static final String STEP_UPDATE = "update";
    public static final String STEP_START = "start";
    private final Log log = LogFactory.getLog(this.getClass());
    private Configuration freemarkerConfiguration;
    private String startStep;
    private String fromVersion;
    private Properties config;

    public InstallServlet(Properties config, String startStep, String fromVersion) {
        this.config = config;
        this.startStep = startStep;
        this.fromVersion = fromVersion;
        this.freemarkerConfiguration = new Configuration(Configuration.getVersion());
        this.freemarkerConfiguration.setClassForTemplateLoading(this.getClass(), "/initialization/");
        this.freemarkerConfiguration.setDefaultEncoding("utf-8");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (CmsVersion.isInitialized()) {
            response.sendError(404);
        } else {
            String step = request.getParameter("step");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("currentVersion", CmsVersion.getVersion());
            if (null == step) {
                step = this.startStep;
            }
            if (null != step) {
                map.put("versions", CmsUpgrader.VERSION_LIST);
                map.put("fromVersion", this.fromVersion);
                switch (step) {
                    case "dataBaseConfig": {
                        InstallServlet.configDatabase(request, map);
                        break;
                    }
                    case "checkDataBase": {
                        InstallServlet.checkDatabse(map);
                        break;
                    }
                    case "initDatabase": {
                        try {
                            this.initDatabase(request.getParameter("useSimple"), map);
                            this.startCMS(map);
                        }
                        catch (Exception e) {
                            map.put("error", e.getMessage());
                        }
                        break;
                    }
                    case "update": {
                        try {
                            this.upgradeDatabase(request.getParameter("from_version"), map);
                            this.startCMS(map);
                        }
                        catch (Exception e) {
                            map.put("message", "failed");
                            map.put("error", e.getMessage());
                        }
                        break;
                    }
                    case "start": {
                        try {
                            this.start();
                            step = "startOk";
                        }
                        catch (PropertyVetoException e) {
                            map.put("message", "failed");
                            map.put("error", e.getMessage());
                        }
                        break;
                    }
                    default: {
                        response.sendError(404);
                    }
                }
            }
            this.render(step, map, response);
        }
    }

    private void start() throws IOException, PropertyVetoException {
        CmsVersion.setInitialized(true);
        CmsDataSource.initDefautlDataSource();
        File file = new File(CommonConstants.CMS_FILEPATH + "/install.lock");
        FileUtils.writeStringToFile((File)file, (String)CmsVersion.getVersion(), (Charset)DEFAULT_CHARSET);
        file.setReadable(true, false);
        file.setWritable(true, false);
        this.log.info((Object)("PublicCMS " + CmsVersion.getVersion() + " started!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configDatabase(HttpServletRequest request, Map<String, Object> map) {
        Connection connection = null;
        try {
            Properties dbconfig = PropertiesLoaderUtils.loadAllProperties((String)"config/database-template.properties");
            String host = request.getParameter("host");
            String port = request.getParameter("port");
            String database = request.getParameter("database");
            CmsUpgrader.setDataBaseUrl(dbconfig, host, port, database);
            dbconfig.setProperty("jdbc.username", request.getParameter("username"));
            dbconfig.setProperty("jdbc.password", request.getParameter("password"));
            String databaseConfiFile = CommonConstants.CMS_FILEPATH + "/database.properties";
            File file = new File(databaseConfiFile);
            try (FileOutputStream fos = new FileOutputStream(file);){
                dbconfig.store(fos, null);
            }
            file.setReadable(true, false);
            file.setWritable(true, false);
            connection = DatabaseUtils.getConnection(databaseConfiFile);
            map.put("message", "success");
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
        }
        finally {
            if (null != connection && null != connection) {
                try {
                    connection.close();
                }
                catch (SQLException e1) {
                    map.put("error", e1.getMessage());
                }
            }
        }
    }

    private static void checkDatabse(Map<String, Object> map) {
        Connection connection = null;
        try {
            String databaseConfiFile = CommonConstants.CMS_FILEPATH + "/database.properties";
            connection = DatabaseUtils.getConnection(databaseConfiFile);
            map.put("message", "success");
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (SQLException e1) {
                    map.put("error", e1.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase(String type, Map<String, Object> map) throws Exception {
        Connection connection = null;
        try {
            String databaseConfiFile = CommonConstants.CMS_FILEPATH + "/database.properties";
            connection = DatabaseUtils.getConnection(databaseConfiFile);
            try {
                map.put("history", this.install(connection, null != type));
                map.put("message", "success");
            }
            catch (Exception e) {
                map.put("message", "failed");
                map.put("error", e.getMessage());
            }
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (SQLException e1) {
                    map.put("error", e1.getMessage());
                }
            }
        }
    }

    private String install(Connection connection, boolean useSimple) throws SQLException, IOException {
        StringWriter stringWriter = new StringWriter();
        ScriptRunner runner = new ScriptRunner(connection);
        runner.setLogWriter(null);
        runner.setErrorLogWriter(new PrintWriter(stringWriter));
        runner.setAutoCommit(true);
        try (InputStream inputStream = this.getClass().getResourceAsStream("/initialization/sql/initDatabase.sql");){
            runner.runScript((Reader)new InputStreamReader(inputStream, DEFAULT_CHARSET));
        }
        if (useSimple) {
            var6_6 = null;
            try (InputStream simpleInputStream = this.getClass().getResourceAsStream("/initialization/sql/initDatabase.sql");){
                runner.runScript((Reader)new InputStreamReader(simpleInputStream, DEFAULT_CHARSET));
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabase(String fromVersion, Map<String, Object> map) throws Exception {
        if (CmsUpgrader.VERSION_LIST.contains(fromVersion)) {
            Connection connection = null;
            try {
                String databaseConfiFile = CommonConstants.CMS_FILEPATH + "/database.properties";
                connection = DatabaseUtils.getConnection(databaseConfiFile);
                CmsUpgrader upgrader = null;
                try {
                    upgrader = new CmsUpgrader(this.config, connection, fromVersion);
                    upgrader.update();
                    map.put("message", "success");
                }
                catch (Exception e) {
                    if (null != upgrader) {
                        fromVersion = upgrader.getVersion();
                    }
                    throw e;
                }
            }
            finally {
                if (null != connection) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e1) {
                        map.put("error", e1.getMessage());
                    }
                }
            }
        }
    }

    private void startCMS(Map<String, Object> map) {
        try {
            this.start();
        }
        catch (Exception e) {
            CmsVersion.setInitialized(false);
            map.put("error", e.getMessage());
        }
    }

    private void render(String step, Map<String, Object> model, HttpServletResponse response) {
        if (!response.isCommitted()) {
            try {
                Template template = this.freemarkerConfiguration.getTemplate(null == step ? "index.html" : step + ".html");
                response.setCharacterEncoding("utf-8");
                response.setContentType("text/html");
                template.process(model, (Writer)response.getWriter());
            }
            catch (TemplateException | IOException throwable) {
                // empty catch block
            }
        }
    }
}

