/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.interceptor;

import com.publiccms.common.base.BaseInterceptor;
import com.publiccms.common.tools.RequestUtils;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.entities.sys.SysUserToken;
import org.publiccms.logic.service.sys.SysUserService;
import org.publiccms.logic.service.sys.SysUserTokenService;
import org.springframework.beans.factory.annotation.Autowired;

public class WebContextInterceptor
extends BaseInterceptor {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserTokenService sysUserTokenService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        block13: {
            response.addHeader(CommonConstants.getXPowered(), CmsVersion.getVersion());
            response.addHeader("Content-Security-Policy", "default-src 'self'; script-src 'self'; frame-ancestors 'self'; object-src 'none'");
            response.addHeader("X-Content-Type-Options", "nosniff");
            HttpSession session = request.getSession();
            String contextPath = request.getContextPath();
            SysUser user = AbstractController.getUserFromSession(session);
            if (null == user) {
                String value;
                Cookie userCookie = RequestUtils.getCookie(request.getCookies(), CommonConstants.getCookiesUser());
                userCookie.setSecure(true);
                if (null != userCookie && StringUtils.isNotBlank((CharSequence)userCookie.getValue()) && null != (value = userCookie.getValue())) {
                    String[] userData = value.split(CommonConstants.getCookiesUserSplit());
                    if (userData.length > 1) {
                        try {
                            Long userId = Long.parseLong(userData[0]);
                            SysUserToken userToken = (SysUserToken)this.sysUserTokenService.getEntity((Serializable)((Object)userData[1]));
                            if (null != userToken && userId.longValue() == userToken.getUserId() && "web".equals(userToken.getChannel()) && null != (user = (SysUser)this.sysUserService.getEntity(userId)) && !user.isDisabled()) {
                                user.setPassword(null);
                                AbstractController.setUserToSession(session, user);
                                break block13;
                            }
                            if (null != userToken) {
                                this.sysUserTokenService.delete((Serializable)((Object)userToken.getAuthToken()));
                            }
                            RequestUtils.cancleCookie(contextPath, response, CommonConstants.getCookiesUser(), null);
                        }
                        catch (NumberFormatException e) {
                            RequestUtils.cancleCookie(contextPath, response, CommonConstants.getCookiesUser(), null);
                        }
                    } else {
                        RequestUtils.cancleCookie(contextPath, response, CommonConstants.getCookiesUser(), null);
                    }
                }
            } else {
                Date date = AbstractController.getUserTimeFromSession(session);
                if (null == date || date.before(DateUtils.addSeconds((Date)new Date(), (int)-30))) {
                    SysUser entity = (SysUser)this.sysUserService.getEntity(user.getId());
                    if (null != entity && !entity.isDisabled()) {
                        user.setName(entity.getName());
                        user.setNickName(entity.getNickName());
                        user.setEmail(entity.getEmail());
                        user.setEmailChecked(entity.isEmailChecked());
                        user.setSuperuserAccess(entity.isSuperuserAccess());
                        AbstractController.setUserToSession(session, user);
                    } else {
                        String[] userData;
                        String value;
                        Cookie userCookie = RequestUtils.getCookie(request.getCookies(), CommonConstants.getCookiesUser());
                        userCookie.setSecure(true);
                        if (null != userCookie && StringUtils.isNotBlank((CharSequence)userCookie.getValue()) && null != (value = userCookie.getValue()) && (userData = value.split(CommonConstants.getCookiesUserSplit())).length > 1) {
                            this.sysUserTokenService.delete((Serializable)((Object)userData[1]));
                        }
                        AbstractController.clearUserToSession(contextPath, session, response);
                    }
                }
            }
        }
        return true;
    }
}

