/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.interceptor;

import com.publiccms.common.base.Base;
import com.publiccms.common.base.BaseInterceptor;
import com.publiccms.common.tools.RequestUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.sys.SysRoleAuthorizedService;
import org.publiccms.logic.service.sys.SysRoleService;
import org.publiccms.logic.service.sys.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminContextInterceptor
extends BaseInterceptor
implements Base {
    private String[] needNotLoginUrls;
    private String[] needNotAuthorizedUrls;
    private String loginUrl;
    private String loginJsonUrl;
    private String unauthorizedUrl;
    @Autowired
    private SysRoleAuthorizedService roleAuthorizedService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysUserService sysUserService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        response.addHeader(CommonConstants.getXPowered(), CmsVersion.getVersion());
        String path = this.urlPathHelper.getLookupPathForRequest(request);
        String ctxPath = this.urlPathHelper.getOriginatingContextPath(request);
        if ("/admin".equals(path)) {
            try {
                response.sendRedirect(ctxPath + "/admin" + "/");
                return false;
            }
            catch (IOException e) {
                return true;
            }
        }
        if (this.verifyNeedLogin(path)) {
            SysUser user = AbstractController.getAdminFromSession(request.getSession());
            if (null == user) {
                try {
                    this.redirectLogin(ctxPath, path, request.getQueryString(), request.getHeader("X-Requested-With"), response);
                    return false;
                }
                catch (IOException | IllegalStateException e) {
                    return true;
                }
            }
            SysUser entity = (SysUser)this.sysUserService.getEntity(user.getId());
            if (!entity.isDisabled() && !entity.isSuperuserAccess()) {
                try {
                    this.redirectLogin(ctxPath, path, request.getQueryString(), request.getHeader("X-Requested-With"), response);
                    return false;
                }
                catch (IOException | IllegalStateException e) {
                    return true;
                }
            }
            if (this.verifyNeedAuthorized(path) && !"/".equals(path)) {
                int index = path.lastIndexOf(".");
                path = path.substring(path.indexOf("/") > 0 ? 0 : 1, index > -1 ? index : path.length());
                if (0 == this.roleAuthorizedService.count(entity.getRoles(), path) && !this.ownsAllRight(entity.getRoles())) {
                    try {
                        response.sendRedirect(ctxPath + this.unauthorizedUrl);
                        return false;
                    }
                    catch (IOException e) {
                        return true;
                    }
                }
                user.setName(entity.getName());
                user.setNickName(entity.getNickName());
                user.setRoles(entity.getRoles());
                user.setDeptId(entity.getDeptId());
                AbstractController.setAdminToSession(request.getSession(), user);
            }
        }
        return true;
    }

    private void redirectLogin(String ctxPath, String path, String queryString, String requestedWith, HttpServletResponse response) throws IOException {
        if ("XMLHttpRequest".equalsIgnoreCase(requestedWith)) {
            response.sendRedirect(ctxPath + this.loginJsonUrl);
        } else {
            StringBuilder sb = new StringBuilder(ctxPath);
            sb.append(this.loginUrl);
            sb.append("?returnUrl=");
            sb.append(RequestUtils.getEncodePath("/admin" + path, queryString));
            response.sendRedirect(sb.toString());
        }
    }

    private boolean ownsAllRight(String roles) {
        String[] roleIdArray = StringUtils.split((String)roles, (String)",");
        if (null != roles && 0 < roleIdArray.length) {
            Integer[] roleIds = new Integer[roleIdArray.length];
            for (int i = 0; i < roleIdArray.length; ++i) {
                roleIds[i] = Integer.parseInt(roleIdArray[i]);
            }
            return this.sysRoleService.ownsAllRight(roleIds);
        }
        return false;
    }

    private boolean verifyNeedLogin(String url) {
        if (null == this.loginUrl) {
            return false;
        }
        if (null != this.needNotLoginUrls && null != url) {
            for (String needNotLoginUrl : this.needNotLoginUrls) {
                if (null == needNotLoginUrl || !url.startsWith(needNotLoginUrl)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean verifyNeedAuthorized(String url) {
        if (null == this.unauthorizedUrl) {
            return false;
        }
        if (null != this.needNotAuthorizedUrls && null != url) {
            for (String needNotAuthorizedUrl : this.needNotAuthorizedUrls) {
                if (null == needNotAuthorizedUrl || !url.startsWith(needNotAuthorizedUrl)) continue;
                return false;
            }
        }
        return true;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = "/admin" + loginUrl;
    }

    public void setNeedNotLoginUrls(String[] needNotLoginUrls) {
        this.needNotLoginUrls = needNotLoginUrls;
    }

    public void setLoginJsonUrl(String loginJsonUrl) {
        this.loginJsonUrl = "/admin" + loginJsonUrl;
    }

    public void setUnauthorizedUrl(String unauthorizedUrl) {
        this.unauthorizedUrl = "/admin" + unauthorizedUrl;
    }

    public void setNeedNotAuthorizedUrls(String[] needNotAuthorizedUrls) {
        this.needNotAuthorizedUrls = needNotAuthorizedUrls;
    }
}

