/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.database;

import com.fasterxml.jackson.core.type.TypeReference;
import com.publiccms.common.base.Base;
import com.publiccms.common.tools.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.views.pojo.CmsModel;
import org.publiccms.views.pojo.ExtendField;

public class CmsUpgrader
implements Base {
    public static final String IDENTIFIER_GENERATOR = "org.hibernate.id.IdentityGenerator";
    public static final String VERSION_20160423 = "V2016.0423";
    public static final String VERSION_20160510 = "V2016.0510";
    public static final String VERSION_20160828 = "V2016.0828";
    public static final String VERSION_20170318 = "V2017.0318";
    public static final String VERSION_20170520 = "V2017.0520";
    public static final List<String> VERSION_LIST = Arrays.asList("V2016.0423", "V2016.0510", "V2016.0828", "V2017.0318", "V2017.0520");
    private Connection connection;
    private String version;
    private Properties config;

    public CmsUpgrader(Properties config, Connection connection, String version) throws Exception {
        this.connection = connection;
        this.config = config;
        this.version = version;
    }

    public void update() throws SQLException, IOException {
        switch (this.version) {
            case "V2016.0423": {
                this.runScript(VERSION_20160423, VERSION_20160510);
            }
            case "V2016.0510": {
                this.runScript(VERSION_20160510, VERSION_20160828);
            }
            case "V2016.0828": {
                this.updateModelToFile();
                this.runScript(VERSION_20160828, VERSION_20170318);
            }
            case "V2017.0318": {
                this.runScript(VERSION_20170318, VERSION_20170520);
            }
            case "V2017.0520": {
                this.runScript(VERSION_20170520, CmsVersion.getVersion());
            }
        }
    }

    private void updateModelToFile() throws SQLException {
        block58: {
            try (Statement statement = this.connection.createStatement();){
                ResultSet rs = statement.executeQuery("select * from cms_model");
                Throwable throwable = null;
                block40: while (true) {
                    try {
                        while (rs.next()) {
                            Map<String, CmsModel> modelMap;
                            CmsModel entity = new CmsModel();
                            String filePath = CommonConstants.CMS_FILEPATH + "/" + "template" + "/" + "/site_" + rs.getString("site_id") + "/" + "model.data";
                            File file = new File(filePath);
                            file.getParentFile().mkdirs();
                            try {
                                modelMap = (Map)objectMapper.readValue(file, (TypeReference)new TypeReference<Map<String, CmsModel>>(){});
                            }
                            catch (IOException | ClassCastException e) {
                                modelMap = new HashMap();
                            }
                            entity.setId(rs.getString("id"));
                            entity.setHasChild(rs.getBoolean("has_child"));
                            entity.setHasFiles(rs.getBoolean("has_files"));
                            entity.setHasImages(rs.getBoolean("has_images"));
                            entity.setName(rs.getString("name"));
                            entity.setOnlyUrl(rs.getBoolean("only_url"));
                            if (null != rs.getString("parent_id")) {
                                entity.setParentId(String.valueOf(rs.getString("parent_id")));
                            }
                            entity.setTemplatePath(rs.getString("template_path"));
                            if (null != rs.getString("extend_id")) {
                                ArrayList<ExtendField> extendList = new ArrayList<ExtendField>();
                                try (Statement extendFieldStatement = this.connection.createStatement();
                                     ResultSet extendFieldRs = extendFieldStatement.executeQuery("select * from sys_extend_field where extend_id = " + rs.getString("extend_id"));){
                                    while (extendFieldRs.next()) {
                                        ExtendField e = new ExtendField(extendFieldRs.getString("code"), extendFieldRs.getString("input_type"), extendFieldRs.getBoolean("required"), extendFieldRs.getString("name"), extendFieldRs.getString("description"), extendFieldRs.getString("default_value"));
                                        extendList.add(e);
                                    }
                                }
                                entity.setExtendList(extendList);
                            }
                            modelMap.put(entity.getId(), entity);
                            try {
                                objectMapper.writeValue(file, modelMap);
                                file.setReadable(true, false);
                                file.setWritable(true, false);
                                continue block40;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block58;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
        }
    }

    private void runScript(String fromVersion, String toVersion) throws SQLException, IOException {
        ScriptRunner runner = new ScriptRunner(this.connection);
        runner.setLogWriter(null);
        runner.setErrorLogWriter(null);
        runner.setAutoCommit(true);
        try (InputStream inputStream = this.getClass().getResourceAsStream("/initialization/upgrade/" + fromVersion + "-" + toVersion + ".sql");){
            if (null != inputStream) {
                runner.runScript((Reader)new InputStreamReader(inputStream, DEFAULT_CHARSET));
            }
        }
        this.version = toVersion;
    }

    public static void setDataBaseUrl(Properties dbconfig, String host, String port, String database) throws IOException, URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:mysql://");
        sb.append(host);
        if (CommonUtils.notEmpty(port) && !"3306".equals(port)) {
            sb.append(":");
            sb.append(port);
        }
        sb.append("/");
        sb.append(database);
        sb.append("?useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=round&useSSL=false");
        dbconfig.setProperty("jdbc.url", sb.toString());
        dbconfig.setProperty("jdbc.driverClassName", "com.mysql.jdbc.Driver");
    }

    public String getVersion() {
        return this.version;
    }
}

