/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.database;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.publiccms.common.datasource.MultiDataSource;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class CmsDataSource
extends MultiDataSource {
    public static final String DATABASE_CONFIG_FILENAME = "/database.properties";
    public static final String DATABASE_CONFIG_TEMPLATE = "config/database-template.properties";
    private static CmsDataSource cmsDataSource;
    private String dbconfigFilePath;
    private Map<Object, Object> dataSources = new HashMap<Object, Object>();

    public CmsDataSource(String filePath) {
        this.dbconfigFilePath = filePath;
        cmsDataSource = this;
    }

    public static Properties loadDatabaseConfig(String configFilePath) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        File file = new File(configFilePath);
        if (!file.exists() && file.getParentFile().exists()) {
            file.createNewFile();
            file.setReadable(true, false);
            file.setWritable(true, false);
        }
        try (FileInputStream fis = new FileInputStream(configFilePath);){
            properties.load(fis);
        }
        return properties;
    }

    public static DataSource initDataSource(Properties properties) throws IOException, PropertyVetoException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(properties.getProperty("jdbc.driverClassName"));
        dataSource.setJdbcUrl(properties.getProperty("jdbc.url"));
        dataSource.setUser(properties.getProperty("jdbc.username"));
        dataSource.setPassword(properties.getProperty("jdbc.password"));
        dataSource.setAutoCommitOnClose(Boolean.parseBoolean(properties.getProperty("cpool.autoCommitOnClose")));
        dataSource.setCheckoutTimeout(Integer.parseInt(properties.getProperty("cpool.checkoutTimeout")));
        dataSource.setInitialPoolSize(Integer.parseInt(properties.getProperty("cpool.minPoolSize")));
        dataSource.setMinPoolSize(Integer.parseInt(properties.getProperty("cpool.minPoolSize")));
        dataSource.setMaxPoolSize(Integer.parseInt(properties.getProperty("cpool.maxPoolSize")));
        dataSource.setMaxIdleTime(Integer.parseInt(properties.getProperty("cpool.maxIdleTime")));
        dataSource.setAcquireIncrement(Integer.parseInt(properties.getProperty("cpool.acquireIncrement")));
        dataSource.setMaxIdleTimeExcessConnections(Integer.parseInt(properties.getProperty("cpool.maxIdleTimeExcessConnections")));
        return dataSource;
    }

    public static void initDefautlDataSource() throws IOException, PropertyVetoException {
        Properties properties = CmsDataSource.loadDatabaseConfig(CmsDataSource.cmsDataSource.dbconfigFilePath);
        DataSource dataSource = CmsDataSource.initDataSource(properties);
        cmsDataSource.getDataSources().put("default", dataSource);
        cmsDataSource.setTargetDataSources(cmsDataSource.getDataSources());
        cmsDataSource.setDefaultTargetDataSource(dataSource);
        cmsDataSource.init();
    }

    public void afterPropertiesSet() {
    }

    public void init() {
        super.afterPropertiesSet();
    }

    public void put(Object name, Object dataSource) {
        this.dataSources.put(name, dataSource);
    }

    public Map<Object, Object> getDataSources() {
        return this.dataSources;
    }
}

