/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.base;

import com.publiccms.common.base.Base;
import com.publiccms.common.directive.BaseTemplateDirective;
import com.publiccms.common.handler.HttpParameterHandler;
import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysAppToken;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.service.sys.SysAppService;
import org.publiccms.logic.service.sys.SysAppTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;

public abstract class AbstractTaskDirective
extends BaseTemplateDirective
implements Base {
    @Autowired
    private SysAppTokenService appTokenService;
    @Autowired
    private SysAppService appService;
    @Autowired
    protected SiteComponent siteComponent;

    public SysSite getSite(RenderHandler handler) throws Exception {
        return (SysSite)handler.getAttribute("site");
    }

    @Override
    public void execute(HttpMessageConverter<Object> httpMessageConverter, MediaType mediaType, HttpServletRequest request, String callback, HttpServletResponse response) throws IOException, Exception {
        HttpParameterHandler handler = new HttpParameterHandler(httpMessageConverter, mediaType, request, callback, response);
        SysApp app = null;
        app = this.getApp(handler);
        if (null == app) {
            handler.put("error", "needAppToken").render();
        } else if (CommonUtils.empty(app.getAuthorizedApis()) || !ArrayUtils.contains((Object[])StringUtils.split((String)app.getAuthorizedApis(), (String)","), (Object)this.getName())) {
            handler.put("error", "unAuthorized").render();
        } else {
            this.execute(handler);
            handler.render();
        }
    }

    protected SysApp getApp(RenderHandler handler) throws Exception {
        SysAppToken appToken = (SysAppToken)this.appTokenService.getEntity((Serializable)((Object)handler.getString("appToken")));
        if (null != appToken) {
            return (SysApp)this.appService.getEntity(Integer.valueOf(appToken.getAppId()));
        }
        return null;
    }
}

