/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.base;

import com.publiccms.common.tools.CommonUtils;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.publiccms.common.view.MultiSiteImportDirective;
import org.publiccms.common.view.MultiSiteIncludeDirective;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.SiteComponent;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class AbstractFreemarkerView
extends FreeMarkerView {
    protected static final String CONTEXT_ADMIN = "admin";
    protected static final String CONTEXT_USER = "user";
    public static final String CONTEXT_DOMAIN = "domain";
    public static final String CONTEXT_SITE = "site";
    public static final String CONTEXT_BASE = "base";
    public static final String CONTEXT_INCLUDE = "include";
    public static final String CONTEXT_IMPORT = "import";
    public static SiteComponent siteComponent;

    protected void exposeHelpers(Map<String, Object> model, HttpServletRequest request) throws Exception {
        AbstractFreemarkerView.exposeAttribute(model, request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
        super.exposeHelpers(model, request);
    }

    public static void exposeAttribute(Map<String, Object> model, String scheme, String serverName, int serverPort, String contextPath) {
        if (80 == serverPort && "http".equals(scheme) || 443 == serverPort && "https".equals(scheme)) {
            model.put(CONTEXT_BASE, scheme + "://" + serverName + contextPath);
        } else {
            model.put(CONTEXT_BASE, scheme + "://" + serverName + ":" + serverPort + contextPath);
        }
        model.put(CONTEXT_DOMAIN, siteComponent.getDomain(serverName));
        AbstractFreemarkerView.exposeSite(model, siteComponent.getSite(serverName));
    }

    public static void exposeSite(Map<String, Object> model, SysSite site) {
        model.put(CONTEXT_SITE, site);
        model.put(CONTEXT_INCLUDE, new MultiSiteIncludeDirective(site));
        model.put(CONTEXT_IMPORT, new MultiSiteImportDirective(site));
    }

    protected void exposeParamters(Map<String, Object> model, HttpServletRequest request) {
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramterName = (String)parameters.nextElement();
            Object[] values = request.getParameterValues(paramterName);
            if (!CommonUtils.notEmpty(values)) continue;
            if (1 < values.length) {
                model.put(paramterName, values);
                continue;
            }
            model.put(paramterName, values[0]);
        }
    }
}

