/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.base;

import com.publiccms.common.base.Base;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.sys.SysDomain;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.service.log.LogOperateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public abstract class AbstractController
implements Base {
    protected static final String REDIRECT = "redirect:";
    protected static final String FORWARD = "forward:";
    protected static final String TEMPLATE_INDEX = "index";
    protected static final String TEMPLATE_DONE = "common/ajaxDone";
    protected static final String TEMPLATE_ERROR = "common/ajaxError";
    protected static final String MESSAGE = "message";
    protected static final String SUCCESS = "success";
    protected static final String ERROR = "error";
    protected static final String ERROR_PAGE = "error.html";
    protected static MediaType jsonMediaType = new MediaType("application", "json", DEFAULT_CHARSET);
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final Pattern TELPHONE_PATTERN = Pattern.compile("^\\+?\\d+([- ]?\\d+)?$");
    public static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]*$");
    public static final Pattern USERNAME_PATTERN = Pattern.compile("^[A-Za-z_]{1}[0-9A-Za-z_]{3,40}$");
    public static final Pattern NICKNAME_PATTERN = Pattern.compile("^[0-9A-Za-z_\u4e00-\ufa29\ue7c7-\ue7f3]{2,45}$");
    private static final String VALID_CHARS = "[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]+]+";
    public static final Pattern EMAIL_PATTERN = Pattern.compile("([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]+]+(\\.[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]+]+)*@[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]+]+(\\.[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]+]+)*)");
    @Autowired
    protected LogOperateService logOperateService;
    @Autowired
    protected SiteComponent siteComponent;
    @Autowired
    protected MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;

    protected SysDomain getDomain(HttpServletRequest request) {
        return this.siteComponent.getDomain(request.getServerName());
    }

    protected SysSite getSite(HttpServletRequest request) {
        return this.siteComponent.getSite(request.getServerName());
    }

    public static SysUser getUserFromSession(HttpSession session) {
        return (SysUser)session.getAttribute(CommonConstants.getSessionUser());
    }

    public static Date getUserTimeFromSession(HttpSession session) {
        return (Date)session.getAttribute(CommonConstants.getSessionUserTime());
    }

    public static void setUserToSession(HttpSession session, SysUser user) {
        session.setAttribute(CommonConstants.getSessionUser(), (Object)user);
        session.setAttribute(CommonConstants.getSessionUserTime(), (Object)CommonUtils.getDate());
    }

    public static void clearUserToSession(String contextPath, HttpSession session, HttpServletResponse response) {
        RequestUtils.cancleCookie(contextPath, response, CommonConstants.getCookiesUser(), null);
        session.removeAttribute(CommonConstants.getSessionUser());
    }

    public static void clearUserTimeToSession(HttpSession session) {
        session.removeAttribute(CommonConstants.getSessionUserTime());
    }

    public static SysUser getAdminFromSession(HttpSession session) {
        return (SysUser)session.getAttribute(CommonConstants.getSessionAdmin());
    }

    public static void setAdminToSession(HttpSession session, SysUser user) {
        session.setAttribute(CommonConstants.getSessionAdmin(), (Object)user);
    }

    public static boolean verifyNotUserName(String value) {
        Matcher m = USERNAME_PATTERN.matcher(value);
        return !m.matches();
    }

    public static boolean verifyNotNickName(String value) {
        Matcher m = NICKNAME_PATTERN.matcher(value);
        return !m.matches();
    }

    protected static boolean verifyNotTelphone(String value) {
        Matcher m = TELPHONE_PATTERN.matcher(value);
        return !m.matches();
    }

    protected static boolean verifyNotEMail(String field, String value, Map<String, Object> model) {
        if (AbstractController.verifyNotEMail(value)) {
            model.put(ERROR, "verify.notEmail." + field);
            return true;
        }
        return false;
    }

    protected static boolean verifyNotUserName(String field, String value, Map<String, Object> model) {
        if (AbstractController.verifyNotUserName(value)) {
            model.put(ERROR, "verify.notUserName." + field);
            return true;
        }
        return false;
    }

    protected static boolean verifyNotNickName(String field, String value, Map<String, Object> model) {
        if (AbstractController.verifyNotNickName(value)) {
            model.put(ERROR, "verify.notNickName." + field);
            return true;
        }
        return false;
    }

    protected static boolean verifyNotTelphone(String field, String value, Map<String, Object> model) {
        if (AbstractController.verifyNotTelphone(value)) {
            model.put(ERROR, "verify.notTelphone." + field);
            return true;
        }
        return false;
    }

    public static boolean verifyNotEMail(String value) {
        Matcher m = EMAIL_PATTERN.matcher(value);
        return !m.matches();
    }

    public static boolean verifyNotNumber(String value) {
        Matcher m = NUMBER_PATTERN.matcher(value);
        return !m.matches();
    }

    protected static boolean verifyNotEMailAndMobile(String field, String value, Map<String, Object> model) {
        if (AbstractController.verifyNotEMail(value) && AbstractController.verifyNotTelphone(value)) {
            model.put(ERROR, "verify.notEmailAndTelphone." + field);
            return true;
        }
        return false;
    }

    public static void clearAdminToSession(HttpSession session) {
        session.removeAttribute(CommonConstants.getSessionAdmin());
    }
}

