/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.common.base;

import com.publiccms.common.base.Base;
import com.publiccms.common.directive.BaseHttpDirective;
import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysAppToken;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.entities.sys.SysUserToken;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.service.sys.SysAppService;
import org.publiccms.logic.service.sys.SysAppTokenService;
import org.publiccms.logic.service.sys.SysUserService;
import org.publiccms.logic.service.sys.SysUserTokenService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAppDirective
extends BaseHttpDirective
implements Base {
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysAppTokenService appTokenService;
    @Autowired
    private SysAppService appService;
    @Autowired
    private SiteComponent siteComponent;

    public SysSite getSite(RenderHandler handler) throws IOException, Exception {
        HttpServletRequest request = handler.getRequest();
        return this.siteComponent.getSite(request.getServerName());
    }

    @Override
    public void execute(RenderHandler handler) throws IOException, Exception {
        SysApp app = null;
        SysUser user = null;
        if (this.needAppToken() && (null == (app = this.getApp(handler)) || CommonUtils.empty(app.getAuthorizedApis()) || !ArrayUtils.contains((Object[])StringUtils.split((String)app.getAuthorizedApis(), (String)","), (Object)this.getName()))) {
            if (null == app) {
                handler.put("error", "needAppToken").render();
            } else {
                handler.put("error", "unAuthorized").render();
            }
        } else if (this.needUserToken() && null == (user = this.getUser(handler))) {
            handler.put("error", "needLogin").render();
        } else {
            this.execute(handler, app, user);
            handler.render();
        }
    }

    protected SysApp getApp(RenderHandler handler) throws Exception {
        SysAppToken appToken = (SysAppToken)this.appTokenService.getEntity((Serializable)((Object)handler.getString("appToken")));
        if (null != appToken) {
            return (SysApp)this.appService.getEntity(Integer.valueOf(appToken.getAppId()));
        }
        return null;
    }

    protected SysUser getUser(RenderHandler handler) throws Exception {
        SysUserToken sysUserToken;
        String authToken = handler.getString("authToken");
        Long authUserId = handler.getLong("authUserId");
        if (CommonUtils.notEmpty(authToken) && null != authUserId && null != (sysUserToken = (SysUserToken)this.sysUserTokenService.getEntity((Serializable)((Object)authToken))) && sysUserToken.getUserId() == authUserId.longValue()) {
            return (SysUser)this.sysUserService.getEntity(Long.valueOf(sysUserToken.getUserId()));
        }
        return null;
    }

    public abstract void execute(RenderHandler var1, SysApp var2, SysUser var3) throws IOException, Exception;

    public abstract boolean needAppToken();

    public abstract boolean needUserToken();
}

