/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.tools;

import com.publiccms.common.base.Base;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtils
implements Base {
    public static boolean zip(String sourceFilePath, String zipFilePath) throws IOException {
        return ZipUtils.zip(sourceFilePath, zipFilePath, true);
    }

    public static boolean zip(String sourceFilePath, String zipFilePath, boolean overwrite) throws IOException {
        if (CommonUtils.notEmpty(sourceFilePath)) {
            File zipFile = new File(zipFilePath);
            if (zipFile.exists() && !overwrite) {
                return false;
            }
            zipFile.getParentFile().mkdirs();
            try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile));){
                ZipUtils.compress(Paths.get(sourceFilePath, new String[0]), zipOutputStream, "");
                zipFile.setReadable(true, false);
                zipFile.setWritable(true, false);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static void compress(Path sourceFilePath, ZipOutputStream out, String basedir) throws IOException {
        if (Files.isDirectory(sourceFilePath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(sourceFilePath);){
                for (Path entry : stream) {
                    String fullName;
                    BasicFileAttributes attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                    String string = fullName = "".equals(basedir) ? entry.toFile().getName() : basedir + "/" + entry.toFile().getName();
                    if (attrs.isDirectory()) {
                        ZipEntry zipEntry = new ZipEntry(fullName + "/");
                        out.putNextEntry(zipEntry);
                        ZipUtils.compress(entry, out, fullName);
                        continue;
                    }
                    ZipUtils.compressFile(entry.toFile(), out, fullName);
                }
            }
            catch (IOException iOException) {}
        } else {
            ZipUtils.compressFile(sourceFilePath.toFile(), out, sourceFilePath.toFile().getName());
        }
    }

    private static void compressFile(File file, ZipOutputStream out, String fullName) throws IOException {
        if (CommonUtils.notEmpty(file)) {
            ZipEntry entry = new ZipEntry(fullName);
            entry.setTime(file.lastModified());
            out.putNextEntry(entry);
            StreamUtils.write((InputStream)new FileInputStream(file), (OutputStream)out, false);
        }
    }

    public static void unzipHere(String zipFilePath) throws IOException {
        int index = zipFilePath.lastIndexOf("/");
        if (0 > index) {
            index = zipFilePath.lastIndexOf("\\");
        }
        ZipUtils.unzip(zipFilePath, zipFilePath.substring(0, index), true);
    }

    public static void unzip(String zipFilePath) throws IOException {
        ZipUtils.unzip(zipFilePath, zipFilePath.substring(0, zipFilePath.lastIndexOf(".")), true);
    }

    public static void unzip(String zipFilePath, String targetPath, boolean overwrite) throws IOException {
        ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration entryEnum = zipFile.getEntries();
        if (null != entryEnum) {
            while (entryEnum.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)entryEnum.nextElement();
                String filePath = zipEntry.getName();
                if (filePath.contains("..")) {
                    filePath = filePath.replace("..", "");
                }
                if (zipEntry.isDirectory()) {
                    File dir = new File(targetPath + File.separator + filePath);
                    dir.mkdirs();
                    continue;
                }
                File targetFile = new File(targetPath + File.separator + filePath);
                if (targetFile.exists() && !overwrite) continue;
                targetFile.getParentFile().mkdirs();
                StreamUtils.write(zipFile.getInputStream(zipEntry), new FileOutputStream(targetFile));
            }
        }
        zipFile.close();
    }

    static {
        System.setProperty("sun.zip.encoding", System.getProperty("sun.jnu.encoding"));
    }
}

