/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.handler;

import com.publiccms.common.base.Base;
import com.publiccms.common.base.BaseHandler;
import com.publiccms.common.handler.RenderHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.TemplateModelUtils;
import freemarker.core.Environment;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class TemplateDirectiveHandler
extends BaseHandler
implements Base {
    private Map<String, TemplateModel> parameters;
    private TemplateModel[] loopVars;
    private TemplateDirectiveBody templateDirectiveBody;
    private Environment environment;

    public TemplateDirectiveHandler(Map<String, TemplateModel> parameters, TemplateModel[] loopVars, Environment environment, TemplateDirectiveBody templateDirectiveBody) throws Exception {
        this.parameters = parameters;
        this.loopVars = loopVars;
        this.templateDirectiveBody = templateDirectiveBody;
        this.environment = environment;
        this.regristerParamters();
    }

    @Override
    public RenderHandler put(String key, Object value) {
        return super.put(key, value);
    }

    @Override
    public void render() throws TemplateException, IOException {
        if (!this.renderd) {
            Map<String, TemplateModel> reduceMap = this.reduce();
            if (null != this.templateDirectiveBody) {
                this.templateDirectiveBody.render(this.environment.getOut());
            }
            this.reduce(reduceMap);
            this.renderd = true;
        }
    }

    @Override
    public void print(String value) throws IOException {
        this.environment.getOut().write(value);
    }

    @Override
    public Writer getWriter() {
        return this.environment.getOut();
    }

    private Map<String, TemplateModel> reduce() throws TemplateModelException {
        LinkedHashMap<String, TemplateModel> reduceMap = new LinkedHashMap<String, TemplateModel>();
        ObjectWrapper objectWrapper = this.environment.getObjectWrapper();
        Environment.Namespace namespace = this.environment.getCurrentNamespace();
        Iterator iterator = this.map.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (i < this.loopVars.length) {
                this.loopVars[i] = objectWrapper.wrap(entry.getValue());
            } else {
                String key = (String)entry.getKey();
                reduceMap.put(key, namespace.get(key));
                namespace.put(key, (Object)objectWrapper.wrap(entry.getValue()));
            }
            ++i;
        }
        return reduceMap;
    }

    private void reduce(Map<String, TemplateModel> reduceMap) {
        if (CommonUtils.notEmpty(reduceMap)) {
            Environment.Namespace namespace = this.environment.getCurrentNamespace();
            namespace.putAll(reduceMap);
        }
    }

    private TemplateModel getModel(String name) {
        return this.parameters.get(name);
    }

    public TemplateHashModelEx getMap(String name) throws TemplateModelException {
        return TemplateModelUtils.converMap(this.getModel(name));
    }

    @Override
    protected String getStringWithoutRegrister(String name) throws TemplateModelException {
        return TemplateModelUtils.converString(this.getModel(name));
    }

    @Override
    public Integer getIntegerWithoutRegrister(String name) throws TemplateModelException {
        return TemplateModelUtils.converInteger(this.getModel(name));
    }

    @Override
    public Short getShort(String name) throws TemplateModelException {
        this.regristerParamter("short", name);
        return TemplateModelUtils.converShort(this.getModel(name));
    }

    @Override
    public Long getLong(String name) throws TemplateModelException {
        this.regristerParamter("long", name);
        return TemplateModelUtils.converLong(this.getModel(name));
    }

    @Override
    public Double getDouble(String name) throws TemplateModelException {
        this.regristerParamter("double", name);
        return TemplateModelUtils.converDouble(this.getModel(name));
    }

    @Override
    protected String[] getStringArrayWithoutRegrister(String name) throws TemplateModelException {
        return TemplateModelUtils.converStringArray(this.getModel(name));
    }

    @Override
    protected Boolean getBooleanWithoutRegrister(String name) throws TemplateModelException {
        return TemplateModelUtils.converBoolean(this.getModel(name));
    }

    @Override
    public Date getDate(String name) throws TemplateModelException, ParseException {
        this.regristerParamter("date", name);
        return TemplateModelUtils.converDate(this.getModel(name));
    }

    @Override
    public Locale getLocale() throws Exception {
        return this.environment.getLocale();
    }

    @Override
    public HttpServletRequest getRequest() throws IOException, Exception {
        HttpRequestHashModel httpRequestHashModel = (HttpRequestHashModel)this.environment.getGlobalVariable("Request");
        if (null != httpRequestHashModel) {
            return httpRequestHashModel.getRequest();
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) throws IOException, Exception {
        TemplateModel model = this.environment.getGlobalVariable(name);
        if (null != model) {
            return TemplateModelUtils.converBean(model);
        }
        return null;
    }
}

