/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.handler;

import com.publiccms.common.base.Base;
import com.publiccms.common.base.BaseHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.TemplateModelUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.servlet.support.RequestContextUtils;

public class HttpParameterHandler
extends BaseHandler
implements Base {
    public static final Pattern FUNCTIONNAME_PATTERN = Pattern.compile("[0-9A-Za-z_\\.]*");
    private MediaType mediaType;
    private HttpMessageConverter<Object> httpMessageConverter;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String callback;

    public HttpParameterHandler(HttpMessageConverter<Object> httpMessageConverter, MediaType mediaType, HttpServletRequest request, String callback, HttpServletResponse response) {
        this.httpMessageConverter = httpMessageConverter;
        this.request = request;
        this.callback = callback;
        this.response = response;
        this.mediaType = mediaType;
        this.regristerParamters();
    }

    @Override
    public void render() throws HttpMessageNotWritableException, IOException {
        if (!this.renderd) {
            Matcher m;
            MappingJacksonValue mappingJacksonValue = new MappingJacksonValue((Object)this.map);
            if (CommonUtils.notEmpty(this.callback) && (m = FUNCTIONNAME_PATTERN.matcher(this.callback)).matches()) {
                mappingJacksonValue.setJsonpFunction(this.callback);
            }
            this.httpMessageConverter.write((Object)mappingJacksonValue, this.mediaType, (HttpOutputMessage)new ServletServerHttpResponse(this.response));
            this.renderd = true;
        }
    }

    @Override
    public void print(String value) throws IOException {
        this.response.getWriter().print(value);
    }

    @Override
    public Writer getWriter() throws IOException {
        return this.response.getWriter();
    }

    @Override
    protected String getStringWithoutRegrister(String name) {
        return this.request.getParameter(name);
    }

    @Override
    protected Integer getIntegerWithoutRegrister(String name) {
        String result = this.getStringWithoutRegrister(name);
        if (CommonUtils.notEmpty(result)) {
            try {
                return Integer.valueOf(result);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Short getShort(String name) {
        this.regristerParamter("string", name);
        String result = this.getStringWithoutRegrister(name);
        if (CommonUtils.notEmpty(result)) {
            try {
                return Short.valueOf(result);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Long getLong(String name) {
        this.regristerParamter("long", name);
        String result = this.getStringWithoutRegrister(name);
        if (CommonUtils.notEmpty(result)) {
            try {
                return Long.valueOf(result);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Double getDouble(String name) {
        this.regristerParamter("double", name);
        String result = this.getStringWithoutRegrister(name);
        if (CommonUtils.notEmpty(result)) {
            try {
                return Double.valueOf(result);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected String[] getStringArrayWithoutRegrister(String name) {
        Object[] values = this.request.getParameterValues(name);
        if (CommonUtils.notEmpty(values) && 1 == values.length && 0 <= ((String)values[0]).indexOf(",")) {
            return StringUtils.split((String)values[0], (String)",");
        }
        return values;
    }

    @Override
    protected Boolean getBooleanWithoutRegrister(String name) {
        String result = this.getStringWithoutRegrister(name);
        if (CommonUtils.notEmpty(result)) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String name) throws ParseException {
        this.regristerParamter("date", name);
        String result = this.getStringWithoutRegrister(name);
        if (CommonUtils.notEmpty(result)) {
            String temp = StringUtils.trimToEmpty((String)result);
            if (TemplateModelUtils.FULL_DATE_LENGTH == temp.length()) {
                DateFormat dateFormat = TemplateModelUtils.FULL_DATE_FORMAT;
                synchronized (dateFormat) {
                    return TemplateModelUtils.FULL_DATE_FORMAT.parse(temp);
                }
            }
            if (TemplateModelUtils.SHORT_DATE_LENGTH == temp.length()) {
                DateFormat dateFormat = TemplateModelUtils.SHORT_DATE_FORMAT;
                synchronized (dateFormat) {
                    return TemplateModelUtils.SHORT_DATE_FORMAT.parse(temp);
                }
            }
            try {
                return new Date(Long.parseLong(temp));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public HttpServletRequest getRequest() throws IOException, Exception {
        return this.request;
    }

    @Override
    public Object getAttribute(String name) throws IOException, Exception {
        return this.request.getAttribute(name);
    }

    @Override
    public Locale getLocale() throws Exception {
        return RequestContextUtils.getLocale((HttpServletRequest)this.request);
    }
}

