/*
 * Decompiled with CFR 0.152.
 */
package com.publiccms.common.base;

import com.publiccms.common.base.Base;
import com.publiccms.common.base.BaseDao;
import com.publiccms.common.datasource.MultiDataSource;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class BaseService<E>
implements Base {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    protected BaseDao<E> dao;

    public E getEntity(Serializable id) {
        return null != id ? (E)this.dao.getEntity(id) : null;
    }

    public E getEntity(Serializable id, String pk) {
        return this.dao.getEntity(id, pk);
    }

    public List<E> getEntitys(Serializable[] ids, String pk) {
        return this.dao.getEntitys(ids, pk);
    }

    public List<E> getEntitys(Serializable[] ids) {
        return this.dao.getEntitys(ids);
    }

    public void delete(Serializable[] ids) {
        for (Serializable id : ids) {
            this.delete(id);
        }
    }

    public void delete(Serializable id) {
        this.dao.delete(id);
    }

    public E update(Serializable id, E newEntity, String[] ignoreProperties) {
        E entity = this.getEntity(id);
        if (null != entity) {
            BeanUtils.copyProperties(this.dao.init(newEntity), entity, (String[])ignoreProperties);
        }
        return entity;
    }

    public E update(Serializable id, E newEntity) {
        E entity = this.getEntity(id);
        if (null != entity) {
            BeanUtils.copyProperties(this.dao.init(newEntity), entity);
        }
        return entity;
    }

    public Serializable save(E entity) {
        return this.dao.save(entity);
    }

    public void save(List<E> entityList) {
        if (CommonUtils.notEmpty(entityList)) {
            for (E entity : entityList) {
                this.save(entity);
            }
        }
    }

    public void setDataSourceName(String dataSourceName) {
        MultiDataSource.setDataSourceName(dataSourceName);
    }

    public void resetDataSourceName() {
        MultiDataSource.resetDataSourceName();
    }
}

