/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.application.RangeRepresentation;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.Method;
import org.restlet.data.Range;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.service.RangeService;

public class RangeFilter
extends Filter {
    public RangeFilter(Context context) {
        super(context);
    }

    protected void afterHandle(Request request, Response response) {
        if (this.getRangeService().isEnabled()) {
            response.getServerInfo().setAcceptRanges(true);
            if (response.isEntityAvailable()) {
                if (request.getRanges().size() == 1) {
                    Range requestedRange = (Range)request.getRanges().get(0);
                    if (!requestedRange.equals((Object)response.getEntity().getRange())) {
                        this.getLogger().info("The range of the response entity is not equal to the requested one.");
                        response.setEntity((Representation)new RangeRepresentation(response.getEntity(), requestedRange));
                    }
                    if (Method.GET.equals((Object)request.getMethod()) && response.getStatus().isSuccess() && !Status.SUCCESS_PARTIAL_CONTENT.equals((Object)response.getStatus())) {
                        response.setStatus(Status.SUCCESS_PARTIAL_CONTENT);
                        this.getLogger().info("The status of a response to a partial GET must be \"206 Partial content\".");
                    }
                } else if (request.getRanges().size() > 1) {
                    response.setStatus(Status.CLIENT_ERROR_REQUESTED_RANGE_NOT_SATISFIABLE);
                    response.setEntity(null);
                }
            }
        }
    }

    public RangeService getRangeService() {
        return this.getApplication().getRangeService();
    }
}

