/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class TurfConversion {
    private static final Map<String, Double> FACTORS = new HashMap<String, Double>();

    private TurfConversion() {
    }

    public static double lengthToDegrees(double distance, String units) {
        return TurfConversion.radiansToDegrees(TurfConversion.lengthToRadians(distance, units));
    }

    public static double degreesToRadians(double degrees) {
        double radians = degrees % 360.0;
        return radians * Math.PI / 180.0;
    }

    public static double radiansToDegrees(double radians) {
        double degrees = radians % (Math.PI * 2);
        return degrees * 180.0 / Math.PI;
    }

    public static double radiansToLength(double radians) {
        return TurfConversion.radiansToLength(radians, "kilometers");
    }

    public static double radiansToLength(double radians, @NonNull String units) {
        return radians * FACTORS.get(units);
    }

    public static double lengthToRadians(double distance) {
        return TurfConversion.lengthToRadians(distance, "kilometers");
    }

    public static double lengthToRadians(double distance, @NonNull String units) {
        return distance / FACTORS.get(units);
    }

    public static double convertLength(@FloatRange(from=0.0) double distance, @NonNull String originalUnit) {
        return TurfConversion.convertLength(distance, originalUnit, "kilometers");
    }

    public static double convertLength(@FloatRange(from=0.0) double distance, @NonNull String originalUnit, @Nullable String finalUnit) {
        if (finalUnit == null) {
            finalUnit = "kilometers";
        }
        return TurfConversion.radiansToLength(TurfConversion.lengthToRadians(distance, originalUnit), finalUnit);
    }

    public static FeatureCollection explode(@NonNull FeatureCollection featureCollection) {
        ArrayList<Feature> finalFeatureList = new ArrayList<Feature>();
        for (Point singlePoint : TurfMeta.coordAll(featureCollection, true)) {
            finalFeatureList.add(Feature.fromGeometry((Geometry)singlePoint));
        }
        return FeatureCollection.fromFeatures(finalFeatureList);
    }

    public static FeatureCollection explode(@NonNull Feature feature) {
        ArrayList<Feature> finalFeatureList = new ArrayList<Feature>();
        for (Point singlePoint : TurfMeta.coordAll(feature, true)) {
            finalFeatureList.add(Feature.fromGeometry((Geometry)singlePoint));
        }
        return FeatureCollection.fromFeatures(finalFeatureList);
    }

    static {
        FACTORS.put("miles", 3960.0);
        FACTORS.put("nauticalmiles", 3441.145);
        FACTORS.put("degrees", 57.2957795);
        FACTORS.put("radians", 1.0);
        FACTORS.put("inches", 2.509056E8);
        FACTORS.put("yards", 6969600.0);
        FACTORS.put("meters", 6373000.0);
        FACTORS.put("centimeters", 6.373E8);
        FACTORS.put("kilometers", 6373.0);
        FACTORS.put("feet", 2.090879265E7);
        FACTORS.put("centimetres", 6.373E8);
        FACTORS.put("metres", 6373000.0);
        FACTORS.put("kilometres", 6373.0);
    }
}

