/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.ModelUtils;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class OperationResponseClassReader
implements RequestMappingReader {
    private static Logger log = LoggerFactory.getLogger(OperationResponseClassReader.class);

    @Override
    public void execute(RequestMappingContext context) {
        ResolvedType returnType;
        SwaggerGlobalSettings swaggerGlobalSettings = (SwaggerGlobalSettings)context.get("swaggerGlobalSettings");
        HandlerMethod handlerMethod = context.getHandlerMethod();
        ApiOperation methodAnnotation = (ApiOperation)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), ApiOperation.class);
        if (null != methodAnnotation && Void.class != methodAnnotation.response()) {
            log.debug("Overriding response class with annotated response class");
            returnType = swaggerGlobalSettings.getTypeResolver().resolve((Type)methodAnnotation.response(), new Type[0]);
        } else {
            returnType = ModelUtils.handlerReturnType(swaggerGlobalSettings.getTypeResolver(), handlerMethod);
            returnType = swaggerGlobalSettings.getAlternateTypeProvider().alternateFor(returnType);
        }
        if (Void.class.equals((Object)returnType.getErasedType()) || Void.TYPE.equals(returnType.getErasedType())) {
            context.put("responseClass", "void");
            return;
        }
        String responseTypeName = ModelUtils.getResponseClassName(returnType);
        log.debug("Setting response class to:" + responseTypeName);
        context.put("responseClass", responseTypeName);
    }
}

