/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Arrays;
import org.eclipse.jgit.JGitText;

public abstract class CredentialItem {
    private final String promptText;
    private final boolean valueSecure;

    public CredentialItem(String promptText, boolean maskValue) {
        this.promptText = promptText;
        this.valueSecure = maskValue;
    }

    public String getPromptText() {
        return this.promptText;
    }

    public boolean isValueSecure() {
        return this.valueSecure;
    }

    public abstract void clear();

    public static class Password
    extends CharArrayType {
        public Password() {
            super(JGitText.get().credentialPassword, true);
        }
    }

    public static class Username
    extends StringType {
        public Username() {
            super(JGitText.get().credentialUsername, false);
        }
    }

    public static class InformationalMessage
    extends CredentialItem {
        public InformationalMessage(String messageText) {
            super(messageText, false);
        }

        public void clear() {
        }
    }

    public static class YesNoType
    extends CredentialItem {
        private boolean value;

        public YesNoType(String promptText) {
            super(promptText, false);
        }

        public void clear() {
            this.value = false;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean newValue) {
            this.value = newValue;
        }
    }

    public static class CharArrayType
    extends CredentialItem {
        private char[] value;

        public CharArrayType(String promptText, boolean maskValue) {
            super(promptText, maskValue);
        }

        public void clear() {
            if (this.value != null) {
                Arrays.fill(this.value, '\u0000');
                this.value = null;
            }
        }

        public char[] getValue() {
            return this.value;
        }

        public void setValue(char[] newValue) {
            this.clear();
            if (newValue != null) {
                this.value = new char[newValue.length];
                System.arraycopy(newValue, 0, this.value, 0, newValue.length);
            }
        }

        public void setValueNoCopy(char[] newValue) {
            this.clear();
            this.value = newValue;
        }
    }

    public static class StringType
    extends CredentialItem {
        private String value;

        public StringType(String promptText, boolean maskValue) {
            super(promptText, maskValue);
        }

        public void clear() {
            this.value = null;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String newValue) {
            this.value = newValue;
        }
    }
}

