/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.util.RawParseUtils;

final class NoteParser
extends CanonicalTreeParser {
    private final AbbreviatedObjectId prefix;
    private final int pathPadding;
    private NonNoteEntry firstNonNote;
    private NonNoteEntry lastNonNote;

    static InMemoryNoteBucket parse(AbbreviatedObjectId prefix, ObjectId treeId, ObjectReader reader) throws IOException {
        return new NoteParser(prefix, reader, treeId).parse();
    }

    private NoteParser(AbbreviatedObjectId p, ObjectReader r, ObjectId t) throws IncorrectObjectTypeException, IOException {
        super(Constants.encodeASCII(p.name()), r, t);
        this.prefix = p;
        int n = this.pathPadding = 0 < this.prefix.length() ? 1 : 0;
        if (0 < this.pathPadding) {
            System.arraycopy(this.path, 0, this.path, this.pathPadding, this.prefix.length());
        }
    }

    private InMemoryNoteBucket parse() {
        InMemoryNoteBucket r = this.parseTree();
        r.nonNotes = this.firstNonNote;
        return r;
    }

    private InMemoryNoteBucket parseTree() {
        while (!this.eof()) {
            if (this.pathLen == this.pathPadding + 40 && this.isHex()) {
                return this.parseLeafTree();
            }
            if (this.getNameLength() == 2 && this.isHex() && this.isTree()) {
                return this.parseFanoutTree();
            }
            this.storeNonNote();
            this.next(1);
        }
        return new LeafBucket(this.prefix.length());
    }

    private LeafBucket parseLeafTree() {
        LeafBucket leaf = new LeafBucket(this.prefix.length());
        MutableObjectId idBuf = new MutableObjectId();
        while (!this.eof()) {
            if (this.parseObjectId(idBuf)) {
                leaf.parseOneEntry(idBuf, this.getEntryObjectId());
            } else {
                this.storeNonNote();
            }
            this.next(1);
        }
        return leaf;
    }

    private boolean parseObjectId(MutableObjectId id) {
        if (this.pathLen == this.pathPadding + 40) {
            try {
                id.fromString(this.path, this.pathPadding);
                return true;
            }
            catch (ArrayIndexOutOfBoundsException notHex) {
                return false;
            }
        }
        return false;
    }

    private FanoutBucket parseFanoutTree() {
        FanoutBucket fanout = new FanoutBucket(this.prefix.length());
        while (!this.eof()) {
            int cell = this.parseFanoutCell();
            if (0 <= cell) {
                fanout.parseOneEntry(cell, this.getEntryObjectId());
            } else {
                this.storeNonNote();
            }
            this.next(1);
        }
        return fanout;
    }

    private int parseFanoutCell() {
        if (this.getNameLength() == 2 && this.isTree()) {
            try {
                return RawParseUtils.parseHexInt4(this.path[this.pathOffset + 0]) << 4 | RawParseUtils.parseHexInt4(this.path[this.pathOffset + 1]);
            }
            catch (ArrayIndexOutOfBoundsException notHex) {
                return -1;
            }
        }
        return -1;
    }

    private void storeNonNote() {
        ObjectId id = this.getEntryObjectId();
        FileMode fileMode = this.getEntryFileMode();
        byte[] name = new byte[this.getNameLength()];
        this.getName(name, 0);
        NonNoteEntry ent = new NonNoteEntry(name, fileMode, id);
        if (this.firstNonNote == null) {
            this.firstNonNote = ent;
        }
        if (this.lastNonNote != null) {
            this.lastNonNote.next = ent;
        }
        this.lastNonNote = ent;
    }

    private boolean isTree() {
        return FileMode.TREE.equals(this.mode);
    }

    private boolean isHex() {
        try {
            for (int i = this.pathOffset; i < this.pathLen; ++i) {
                RawParseUtils.parseHexInt4(this.path[i]);
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException fail) {
            return false;
        }
    }
}

