/*
 * Decompiled with CFR 0.152.
 */
package com.linkage.netmsg;

import com.linkage.netmsg.MsgConst;
import com.linkage.netmsg.NetMd5;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;

public class NetMsgclient {
    protected Socket socket = new Socket();
    protected InputStream input = null;
    protected OutputStream output = null;
    public static int seq = 0;
    private String ipAddress;
    private int port;
    private String username;
    private String password;

    public void connect(String host, int port) throws IOException {
        if (!this.socket.isConnected()) {
            InetSocketAddress endpoint = new InetSocketAddress(host, port);
            this.socket.connect(endpoint, 10000);
        }
    }

    public void connect() throws IOException {
        if (!this.socket.isConnected()) {
            InetSocketAddress endpoint = new InetSocketAddress(this.ipAddress, this.port);
            this.socket.connect(endpoint, 10000);
        }
    }

    public void disconnect() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public void forceDisconnect() throws IOException {
        this.socket.close();
    }

    public boolean anthenMsg() throws IOException {
        return this.msgRequest(this.username, this.password);
    }

    public boolean msgRequest(String account, String verifyCode) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_REQ.clone();
        byte[] usrBuf = account.getBytes();
        byte[] pwdBuf = NetMd5.GetByteMD5(String.valueOf(account) + verifyCode);
        int length = 0;
        length = (short)(length + 6);
        short a_length = (short)(4 + usrBuf.length);
        short v_length = (short)(4 + pwdBuf.length);
        Pattern[1] = length = (int)((short)(length + a_length + v_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)2);
        byteBuf.putShort(a_length);
        byteBuf.put(usrBuf);
        byteBuf.putShort((short)3);
        byteBuf.putShort(v_length);
        byteBuf.put(pwdBuf);
        return this.checkResponse(this.send(byteBuf.array(), 14));
    }

    public int recordQFS(String srcPhone, String recPhone, String msg) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
        byte[] recPhoneBuf = recPhone.getBytes();
        byte[] srcPhoneBuf = srcPhone.getBytes();
        byte[] msgBuf = msg.getBytes();
        int length = 0;
        int seq = this.getSeq();
        length = (short)(length + 6);
        short a_length = 8;
        short c_length = (short)(4 + recPhoneBuf.length);
        short e_length = (short)(4 + srcPhoneBuf.length);
        short d_length = (short)(4 + msgBuf.length);
        Pattern[1] = length = (int)((short)(length + a_length + c_length + d_length + e_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)4);
        byteBuf.putShort(a_length);
        byteBuf.putInt(seq);
        byteBuf.putShort((short)6);
        byteBuf.putShort(c_length);
        byteBuf.put(recPhoneBuf);
        byteBuf.putShort((short)8);
        byteBuf.putShort(e_length);
        byteBuf.put(srcPhoneBuf);
        byteBuf.putShort((short)7);
        byteBuf.putShort(d_length);
        byteBuf.put(msgBuf);
        return this.checkBodyResponse(this.send(byteBuf.array(), 22));
    }

    public int recordLDF(int enterpriseId, String srcPhone, String recPhone, String msg) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
        byte[] recPhoneBuf = recPhone.getBytes();
        byte[] srcPhoneBuf = srcPhone.getBytes();
        byte[] msgBuf = msg.getBytes();
        int length = 0;
        int seq = this.getSeq();
        length = (short)(length + 6);
        short a_length = 8;
        short c_length = (short)(4 + recPhoneBuf.length);
        short d_length = (short)(4 + msgBuf.length);
        short e_length = 8;
        short f_length = (short)(4 + srcPhoneBuf.length);
        Pattern[1] = length = (int)((short)(length + a_length + c_length + d_length + e_length + f_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)4);
        byteBuf.putShort(a_length);
        byteBuf.putInt(seq);
        byteBuf.putShort((short)6);
        byteBuf.putShort(c_length);
        byteBuf.put(recPhoneBuf);
        byteBuf.putShort((short)7);
        byteBuf.putShort(d_length);
        byteBuf.put(msgBuf);
        byteBuf.putShort((short)9);
        byteBuf.putShort(e_length);
        byteBuf.putInt(enterpriseId);
        byteBuf.putShort((short)8);
        byteBuf.putShort(f_length);
        byteBuf.put(srcPhoneBuf);
        return this.checkBodyResponse(this.send(byteBuf.array(), 22));
    }

    public int recordCommon(int sendType, String recPhone, String msg) throws IOException {
        short[] Pattern = (short[])MsgConst.NET_HEAD_BODY_REQ.clone();
        byte[] recPhoneBuf = recPhone.getBytes();
        byte[] msgBuf = msg.getBytes();
        int length = 0;
        int seq = this.getSeq();
        length = (short)(length + 6);
        short a_length = 8;
        short b_length = 8;
        short c_length = (short)(4 + recPhoneBuf.length);
        short d_length = (short)(4 + msgBuf.length);
        Pattern[1] = length = (int)((short)(length + a_length + b_length + c_length + d_length));
        ByteBuffer byteBuf = ByteBuffer.allocate(length);
        int i = 0;
        while (i < Pattern.length) {
            byteBuf.putShort(Pattern[i]);
            ++i;
        }
        byteBuf.putShort((short)4);
        byteBuf.putShort(a_length);
        byteBuf.putInt(seq);
        byteBuf.putShort((short)5);
        byteBuf.putShort(b_length);
        byteBuf.putInt(sendType);
        byteBuf.putShort((short)6);
        byteBuf.putShort(c_length);
        byteBuf.put(recPhoneBuf);
        byteBuf.putShort((short)7);
        byteBuf.putShort(d_length);
        byteBuf.put(msgBuf);
        return this.checkBodyResponse(this.send(byteBuf.array(), 22));
    }

    public synchronized int getSeq() {
        return ++seq;
    }

    public byte[] ints2bytes(short[] num) {
        int len = num.length * 4;
        byte[] b = new byte[len];
        int i = 0;
        while (i < num.length) {
            int j = 0;
            while (j < 4) {
                b[i * 4 + j] = (byte)(num[i] >>> 24 - j * 8);
                ++j;
            }
            ++i;
        }
        return b;
    }

    protected byte[] send(byte[] data, int rep_size) throws IOException {
        if (this.input == null) {
            this.input = new DataInputStream(this.socket.getInputStream());
        }
        if (this.output == null) {
            this.output = new DataOutputStream(this.socket.getOutputStream());
        }
        this.output.write(data);
        this.output.flush();
        byte[] rep = new byte[rep_size];
        for (int Timeout = 15000; this.input.available() < rep_size && Timeout > 0; Timeout -= 5) {
            try {
                Thread.sleep(5L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.input.read(rep);
        return rep;
    }

    public void initParameters(String ipAddress, int port, String username, String password) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public static void main(String[] args) throws IOException {
        NetMsgclient client = new NetMsgclient();
        try {
            client.connect("218.94.58.243", 9001);
            boolean result = client.msgRequest("ldf_test", "!ldf_test!");
            if (result) {
                System.out.println("\u9a8c\u8bc1\u6210\u529f");
            } else {
                System.out.println("\u9a8c\u8bc1\u5931\u8d25");
            }
            int i = 0;
            while (i < 2) {
                int rep = client.recordLDF(205, "02585228753", "13770600365", "\u9ec4");
                if (rep > -1) {
                    if (rep == 0) {
                        System.out.println("\u63d0\u4ea4\u6210\u529f");
                    } else {
                        System.out.println("\u63d0\u4ea4\u5931\u8d25");
                    }
                }
                ++i;
            }
            client.disconnect();
        }
        catch (Exception e) {
            client.forceDisconnect();
        }
    }

    public int checkHeadResponse(byte[] rep) {
        int ret = -1;
        ByteBuffer buf = ByteBuffer.wrap(rep);
        buf.getShort();
        buf.getShort();
        short headType = buf.getShort();
        if (headType == MsgConst.NET_HEAD_RSP[2]) {
            buf.getShort();
            buf.getShort();
            ret = buf.getInt();
        }
        return ret;
    }

    public int checkBodyResponse(byte[] rep) {
        int ret = -1;
        ByteBuffer buf = ByteBuffer.wrap(rep);
        buf.getShort();
        buf.getShort();
        short headType = buf.getShort();
        if (headType == MsgConst.NET_HEAD_BODY_RSP[2]) {
            while (buf.remaining() > 0) {
                short type = buf.getShort();
                if (type == 1) {
                    buf.getShort();
                    ret = buf.getInt();
                    continue;
                }
                short length = buf.getShort();
                buf.position(buf.position() + length - 4);
            }
        }
        System.out.println(ret);
        return ret;
    }

    public boolean checkResponse(byte[] rep) {
        ByteBuffer buf = ByteBuffer.wrap(rep);
        buf.getShort();
        buf.getShort();
        buf.getShort();
        buf.getShort();
        buf.getShort();
        int ret = buf.getInt();
        System.out.println(ret);
        return ret == 0;
    }
}

