/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.symmetric;

import com.koalii.kgsp.bc.crypto.engines.SM4Engine;
import com.koalii.kgsp.bc.crypto.modes.CBCBlockCipher;
import com.koalii.kgsp.bc.crypto.paddings.PKCS7Padding;
import com.koalii.kgsp.bc.crypto.paddings.PaddedBufferedBlockCipher;
import com.koalii.kgsp.bc.crypto.paddings.ZeroBytePadding;
import com.koalii.kgsp.bc.crypto.params.KeyParameter;
import com.koalii.kgsp.bc.crypto.params.ParametersWithIV;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.spec.IvParameterSpec;

public class SM4Util {
    public static final int ENCRYPT = 1;
    public static final int DECRYPT = 0;
    public static final int ROUND = 32;
    private static final int BLOCK = 16;
    public static final String PADDING_ZERO = "PADDING_ZERO";
    public static final String PADDING_PKCS7 = "PADDING_PKCS7";
    private byte[] Sbox = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    private int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};

    private int Rotl(int x, int y) {
        return x << y | x >>> 32 - y;
    }

    private int ByteSub(int A) {
        return (this.Sbox[A >>> 24 & 0xFF] & 0xFF) << 24 | (this.Sbox[A >>> 16 & 0xFF] & 0xFF) << 16 | (this.Sbox[A >>> 8 & 0xFF] & 0xFF) << 8 | this.Sbox[A & 0xFF] & 0xFF;
    }

    private int L1(int B) {
        return B ^ this.Rotl(B, 2) ^ this.Rotl(B, 10) ^ this.Rotl(B, 18) ^ this.Rotl(B, 24);
    }

    private int L2(int B) {
        return B ^ this.Rotl(B, 13) ^ this.Rotl(B, 23);
    }

    void SMS4Crypt(byte[] Input, byte[] Output, int[] rk) {
        int[] x = new int[4];
        int[] tmp = new int[4];
        for (int i = 0; i < 4; ++i) {
            tmp[0] = Input[0 + 4 * i] & 0xFF;
            tmp[1] = Input[1 + 4 * i] & 0xFF;
            tmp[2] = Input[2 + 4 * i] & 0xFF;
            tmp[3] = Input[3 + 4 * i] & 0xFF;
            x[i] = tmp[0] << 24 | tmp[1] << 16 | tmp[2] << 8 | tmp[3];
        }
        for (int r = 0; r < 32; r += 4) {
            int mid = x[1] ^ x[2] ^ x[3] ^ rk[r + 0];
            mid = this.ByteSub(mid);
            x[0] = x[0] ^ this.L1(mid);
            mid = x[2] ^ x[3] ^ x[0] ^ rk[r + 1];
            mid = this.ByteSub(mid);
            x[1] = x[1] ^ this.L1(mid);
            mid = x[3] ^ x[0] ^ x[1] ^ rk[r + 2];
            mid = this.ByteSub(mid);
            x[2] = x[2] ^ this.L1(mid);
            mid = x[0] ^ x[1] ^ x[2] ^ rk[r + 3];
            mid = this.ByteSub(mid);
            x[3] = x[3] ^ this.L1(mid);
        }
        for (int j = 0; j < 16; j += 4) {
            Output[j] = (byte)(x[3 - j / 4] >>> 24 & 0xFF);
            Output[j + 1] = (byte)(x[3 - j / 4] >>> 16 & 0xFF);
            Output[j + 2] = (byte)(x[3 - j / 4] >>> 8 & 0xFF);
            Output[j + 3] = (byte)(x[3 - j / 4] & 0xFF);
        }
    }

    private void SMS4KeyExt(byte[] Key2, int[] rk, int CryptFlag) {
        int mid;
        int r;
        int[] x = new int[4];
        int[] tmp = new int[4];
        for (int i = 0; i < 4; ++i) {
            tmp[0] = Key2[0 + 4 * i] & 0xFF;
            tmp[1] = Key2[1 + 4 * i] & 0xFF;
            tmp[2] = Key2[2 + 4 * i] & 0xFF;
            tmp[3] = Key2[3 + 4 * i] & 0xFF;
            x[i] = tmp[0] << 24 | tmp[1] << 16 | tmp[2] << 8 | tmp[3];
        }
        x[0] = x[0] ^ 0xA3B1BAC6;
        x[1] = x[1] ^ 0x56AA3350;
        x[2] = x[2] ^ 0x677D9197;
        x[3] = x[3] ^ 0xB27022DC;
        for (r = 0; r < 32; r += 4) {
            mid = x[1] ^ x[2] ^ x[3] ^ this.CK[r + 0];
            mid = this.ByteSub(mid);
            rk[r + 0] = x[0] = x[0] ^ this.L2(mid);
            mid = x[2] ^ x[3] ^ x[0] ^ this.CK[r + 1];
            mid = this.ByteSub(mid);
            rk[r + 1] = x[1] = x[1] ^ this.L2(mid);
            mid = x[3] ^ x[0] ^ x[1] ^ this.CK[r + 2];
            mid = this.ByteSub(mid);
            rk[r + 2] = x[2] = x[2] ^ this.L2(mid);
            mid = x[0] ^ x[1] ^ x[2] ^ this.CK[r + 3];
            mid = this.ByteSub(mid);
            rk[r + 3] = x[3] = x[3] ^ this.L2(mid);
        }
        if (CryptFlag == 0) {
            for (r = 0; r < 16; ++r) {
                mid = rk[r];
                rk[r] = rk[31 - r];
                rk[31 - r] = mid;
            }
        }
    }

    public int sms4_ecb(byte[] in, int inLen, byte[] key, byte[] out, int CryptFlag) {
        int point = 0;
        int[] round_key = new int[32];
        this.SMS4KeyExt(key, round_key, CryptFlag);
        byte[] input = new byte[16];
        byte[] output = new byte[16];
        while (inLen >= 16) {
            input = Arrays.copyOfRange(in, point, point + 16);
            this.SMS4Crypt(input, output, round_key);
            System.arraycopy(output, 0, out, point, 16);
            inLen -= 16;
            point += 16;
        }
        return 0;
    }

    public void xors(byte[] iv, byte[] in) {
        for (int i = 0; i < in.length; ++i) {
            in[i] = (byte)(in[i] ^ iv[i]);
        }
    }

    public int sms4_cbc(byte[] in, int inLen, byte[] key, byte[] iv, byte[] out, int CryptFlag) {
        int point = 0;
        int[] round_key = new int[32];
        this.SMS4KeyExt(key, round_key, CryptFlag);
        byte[] input = new byte[16];
        byte[] output = new byte[16];
        byte[] tmpIV = new byte[16];
        if (CryptFlag == 1) {
            System.arraycopy(iv, 0, tmpIV, 0, 16);
            while (inLen >= 16) {
                input = Arrays.copyOfRange(in, point, point + 16);
                this.xors(tmpIV, input);
                this.SMS4Crypt(input, output, round_key);
                System.arraycopy(output, 0, tmpIV, 0, 16);
                System.arraycopy(output, 0, out, point, 16);
                inLen -= 16;
                point += 16;
            }
        } else {
            System.arraycopy(iv, 0, tmpIV, 0, 16);
            while (inLen >= 16) {
                input = Arrays.copyOfRange(in, point, point + 16);
                this.SMS4Crypt(input, output, round_key);
                this.xors(tmpIV, output);
                System.arraycopy(input, 0, tmpIV, 0, 16);
                System.arraycopy(output, 0, out, point, 16);
                inLen -= 16;
                point += 16;
            }
        }
        return 0;
    }

    public byte[] SM4EncryptECB(byte[] in, byte[] key) {
        int inlen = in.length;
        byte[] out = new byte[inlen];
        this.sms4_ecb(in, inlen, key, out, 1);
        return out;
    }

    public byte[] SM4DecryptECB(byte[] in, byte[] key) {
        int inlen = in.length;
        byte[] out = new byte[inlen];
        this.sms4_ecb(in, inlen, key, out, 0);
        return out;
    }

    public byte[] SM4EncryptCBC(byte[] in, byte[] key) {
        int inlen = in.length;
        byte[] out = new byte[inlen];
        byte[] iv = new byte[16];
        this.sms4_cbc(in, inlen, key, iv, out, 1);
        return out;
    }

    public byte[] SM4DecryptCBC(byte[] in, byte[] key) {
        int inlen = in.length;
        byte[] out = new byte[inlen];
        byte[] iv = new byte[16];
        this.sms4_cbc(in, inlen, key, iv, out, 0);
        return out;
    }

    public void encrypt(String inpath, String outpath, byte[] key) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(inpath);
            out = new FileOutputStream(outpath);
            int blockSize = 8192;
            int outputSize = 8192;
            byte[] inBytes = new byte[blockSize];
            byte[] outBytes = new byte[outputSize];
            byte[] lastBytes = null;
            int inLength = 0;
            boolean more = true;
            while (more) {
                inLength = ((InputStream)in).read(inBytes);
                if (inLength == blockSize) {
                    outBytes = this.SM4EncryptECB(inBytes, key);
                    out.write(outBytes, 0, outBytes.length);
                    continue;
                }
                if (inLength > 0) {
                    lastBytes = new byte[inLength];
                    System.arraycopy(inBytes, 0, lastBytes, 0, inLength);
                } else {
                    lastBytes = new byte[]{};
                }
                more = false;
            }
            outBytes = this.SM4EncryptECB(SM4Util.enc_data_format(lastBytes), key);
            out.write(outBytes, 0, outBytes.length);
            out.flush();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }

    public void decrypt(String inpath, String outpath, byte[] key) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(inpath);
            out = new FileOutputStream(outpath);
            int blockSize = 8192;
            int outputSize = 8192;
            byte[] inBytes = new byte[blockSize];
            byte[] outBytes = new byte[outputSize];
            int inLength = 0;
            boolean more = true;
            boolean first = true;
            while (more) {
                inLength = ((InputStream)in).read(inBytes);
                if (inLength > 0) {
                    if (!first) {
                        outBytes = this.SM4DecryptECB(outBytes, key);
                        out.write(outBytes, 0, outBytes.length);
                    }
                    if (inLength != outBytes.length) {
                        outBytes = new byte[inLength];
                    }
                    System.arraycopy(inBytes, 0, outBytes, 0, inLength);
                } else {
                    outBytes = this.SM4DecryptECB(outBytes, key);
                    outBytes = SM4Util.dec_data_format(outBytes);
                    out.write(outBytes, 0, outBytes.length);
                    more = false;
                }
                first = false;
            }
            out.flush();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }

    public byte[] encryptCbc(byte[] key, byte[] plainTxt) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(plainTxt);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int blockSize = 8192;
        int outputSize = 8192;
        byte[] inBytes = new byte[blockSize];
        byte[] outBytes = new byte[outputSize];
        byte[] lastBytes = null;
        int inLength = 0;
        boolean more = true;
        while (more) {
            inLength = bin.read(inBytes, 0, blockSize);
            if (inLength == blockSize) {
                outBytes = this.SM4EncryptCBC(inBytes, key);
                bout.write(outBytes, 0, outBytes.length);
                continue;
            }
            if (inLength > 0) {
                lastBytes = new byte[inLength];
                System.arraycopy(inBytes, 0, lastBytes, 0, inLength);
            } else {
                lastBytes = new byte[]{};
            }
            more = false;
        }
        outBytes = this.SM4EncryptCBC(lastBytes, key);
        bout.write(outBytes, 0, outBytes.length);
        return bout.toByteArray();
    }

    public byte[] decryptCbc(byte[] key, byte[] plainTxt) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(plainTxt);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int blockSize = 8192;
        int outputSize = 8192;
        byte[] inBytes = new byte[blockSize];
        byte[] outBytes = new byte[outputSize];
        int inLength = 0;
        boolean more = true;
        boolean first = true;
        while (more) {
            inLength = bin.read(inBytes, 0, blockSize);
            if (inLength > 0) {
                if (!first) {
                    outBytes = this.SM4DecryptCBC(outBytes, key);
                    bout.write(outBytes, 0, outBytes.length);
                }
                if (inLength != outBytes.length) {
                    outBytes = new byte[inLength];
                }
                System.arraycopy(inBytes, 0, outBytes, 0, inLength);
            } else {
                outBytes = this.SM4DecryptCBC(outBytes, key);
                bout.write(outBytes, 0, outBytes.length);
                more = false;
            }
            first = false;
        }
        return bout.toByteArray();
    }

    public static byte[] enc_data_format(byte[] data) {
        int num = 16 - data.length % 16;
        int tmpb = 0;
        for (int i = 1; i <= num; ++i) {
            tmpb = (byte)(tmpb + 1);
        }
        byte[] bubyte = new byte[num];
        for (int i = 0; i < num; ++i) {
            bubyte[i] = tmpb;
        }
        byte[] formatdata = new byte[data.length + bubyte.length];
        System.arraycopy(data, 0, formatdata, 0, data.length);
        System.arraycopy(bubyte, 0, formatdata, data.length, bubyte.length);
        return formatdata;
    }

    public static byte[] dec_data_format(byte[] data) {
        int num = data[data.length - 1] / 1;
        byte[] formatdata = new byte[data.length - num];
        System.arraycopy(data, 0, formatdata, 0, data.length - num);
        return formatdata;
    }

    public byte[] generateKey() throws Exception {
        Random random = new Random();
        byte[] key = new byte[16];
        random.nextBytes(key);
        return key;
    }

    public int encAndDec(byte[] key, InputStream inputStream, OutputStream outputStream, String paddingType, boolean isEnc) throws Exception {
        int outlen;
        int inlen;
        if (null == key || null == inputStream || null == paddingType) {
            throw new IllegalArgumentException();
        }
        CBCBlockCipher cbc = new CBCBlockCipher(new SM4Engine());
        byte[] rand = new byte[16];
        IvParameterSpec zeroIv = new IvParameterSpec(rand);
        KeyParameter p = new KeyParameter(key);
        ParametersWithIV param = new ParametersWithIV(p, zeroIv.getIV());
        cbc.init(isEnc, param);
        PaddedBufferedBlockCipher cipher = null;
        if (paddingType.equals(PADDING_PKCS7)) {
            cipher = new PaddedBufferedBlockCipher(cbc, new PKCS7Padding());
        } else if (paddingType.equals(PADDING_ZERO)) {
            cipher = new PaddedBufferedBlockCipher(cbc, new ZeroBytePadding());
        }
        cipher.init(isEnc, new KeyParameter(key));
        int inBlockSize = cipher.getBlockSize() * 256;
        int outBlockSize = cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        while ((inlen = inputStream.read(inblock, 0, inBlockSize)) != -1) {
            outlen = cipher.processBytes(inblock, 0, inlen, outblock, 0);
            if (outlen <= 0) continue;
            outputStream.write(outblock, 0, outlen);
        }
        outlen = cipher.doFinal(outblock, 0);
        if (outlen > 0) {
            outputStream.write(outblock, 0, outlen);
        }
        return 0;
    }
}

