/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.digest;

import com.koalii.kgsp.bc.asn1.gm.GMObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.x9.X9ECParameters;
import com.koalii.kgsp.bc.crypto.digests.SM3Digest;
import com.koalii.kgsp.bc.crypto.ec.CustomNamedCurves;
import com.koalii.kgsp.bc.crypto.params.ECDomainParameters;
import com.koalii.kgsp.bc.crypto.params.ECNamedDomainParameters;
import com.koalii.kgsp.bc.crypto.params.ECPrivateKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ECPublicKeyParameters;
import com.koalii.kgsp.bc.math.ec.ECFieldElement;
import com.koalii.kgsp.bc.math.ec.ECPoint;
import com.koalii.kgsp.bc.math.ec.FixedPointCombMultiplier;
import com.koalii.kgsp.bc.util.encoders.Hex;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sm3WithSm2
extends MessageDigest {
    public static final String DEFUSERID = "31323334353637383132333435363738";
    private SM3Digest sm3Digest = new SM3Digest();
    private byte[] z = null;
    private boolean zNotAppended = true;
    private ECPoint pubPoint = null;
    private ECDomainParameters ecParams = null;

    public Sm3WithSm2(ECPublicKeyParameters pubKey) throws NoSuchAlgorithmException {
        this(DEFUSERID, pubKey);
    }

    public Sm3WithSm2(ECPrivateKeyParameters ecKey) throws NoSuchAlgorithmException {
        this(DEFUSERID, ecKey);
    }

    public Sm3WithSm2(ECPoint pubPoint) throws NoSuchAlgorithmException {
        this(DEFUSERID, pubPoint, null);
    }

    public Sm3WithSm2(String userId, ECPoint pubPoint, ECDomainParameters ecParams) throws NoSuchAlgorithmException {
        super("Sm3WithSm2");
        this.ecParams = ecParams;
        this.pubPoint = pubPoint;
        if (null == this.ecParams) {
            X9ECParameters x9 = CustomNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1);
            if (null == x9) {
                throw new NoSuchAlgorithmException("can't find sm2 Curves by " + GMObjectIdentifiers.sm2p256v1);
            }
            this.ecParams = new ECNamedDomainParameters(GMObjectIdentifiers.sm2p256v1, x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        }
        this.z = this.calcZ(userId);
    }

    public Sm3WithSm2(String userId, ECPrivateKeyParameters ecKey) throws NoSuchAlgorithmException {
        super("Sm3WithSm2");
        this.ecParams = ecKey.getParameters();
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        this.pubPoint = multiplier.multiply(this.ecParams.getG(), ecKey.getD()).normalize();
        this.z = this.calcZ(userId);
    }

    public Sm3WithSm2(String userId, ECPublicKeyParameters pubKey) throws NoSuchAlgorithmException {
        super("Sm3WithSm2");
        this.ecParams = pubKey.getParameters();
        this.pubPoint = pubKey.getQ();
        this.z = this.calcZ(userId);
    }

    private void addUserID(SM3Digest digest, byte[] userID) {
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
    }

    private void addFieldElement(SM3Digest digest, ECFieldElement v) {
        byte[] p = v.getEncoded();
        digest.update(p, 0, p.length);
    }

    private byte[] calcZ(byte[] userId) {
        this.sm3Digest.reset();
        this.addUserID(this.sm3Digest, userId);
        this.addFieldElement(this.sm3Digest, this.ecParams.getCurve().getA());
        this.addFieldElement(this.sm3Digest, this.ecParams.getCurve().getB());
        this.addFieldElement(this.sm3Digest, this.ecParams.getG().getAffineXCoord());
        this.addFieldElement(this.sm3Digest, this.ecParams.getG().getAffineYCoord());
        this.addFieldElement(this.sm3Digest, this.pubPoint.getAffineXCoord());
        this.addFieldElement(this.sm3Digest, this.pubPoint.getAffineYCoord());
        byte[] bout = new byte[this.sm3Digest.getDigestSize()];
        this.sm3Digest.doFinal(bout, 0);
        return bout;
    }

    private byte[] calcZ(String userId) {
        return this.calcZ(Hex.decode(userId));
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.zNotAppended) {
            this.sm3Digest.update(this.z, 0, this.z.length);
            this.zNotAppended = false;
        }
        this.sm3Digest.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (this.zNotAppended) {
            this.sm3Digest.update(this.z, 0, this.z.length);
            this.zNotAppended = false;
        }
        this.sm3Digest.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] bout = new byte[this.sm3Digest.getDigestSize()];
        this.sm3Digest.doFinal(bout, 0);
        return bout;
    }

    @Override
    protected void engineReset() {
        this.zNotAppended = true;
        this.sm3Digest.reset();
    }
}

