/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util;

import com.koalii.kgsp.core.util.LogUtil;
import com.koalii.util.FileUtil;
import com.koalii.util.SafeProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class SysUtil {
    private static final String SYS_CONF_PATH = "conf/svsclient.properties";
    private static String sysConfigFile = null;
    private static Properties prop = null;

    public static Properties getSysProperties() {
        if (null == sysConfigFile) {
            SysUtil.createSysProperties();
        }
        return SysUtil.getProperties(sysConfigFile);
    }

    private static void createSysProperties() {
        String path;
        if (null == sysConfigFile && !new File(sysConfigFile = (path = (path = SysUtil.getSysPath()).lastIndexOf("/") == path.length() - 1 || path.lastIndexOf("\\") == path.length() - 1 ? path + SYS_CONF_PATH : path + "/conf/svsclient.properties")).exists()) {
            SysUtil.createConfig(sysConfigFile);
        }
    }

    public static String getSysPath() {
        String path = System.getenv("SVS_CLIENT");
        if (null != path) {
            return path;
        }
        if (SysUtil.isWindows()) {
            return "C:/koalii/svsclient";
        }
        return "/etc/koalii/svsclient";
    }

    public static String getSysConfig(String key) {
        Properties prop = SysUtil.getSysProperties();
        return prop.getProperty(key);
    }

    public static int updateSysConfig(String key, String value) {
        if (null == sysConfigFile) {
            SysUtil.createSysProperties();
        }
        return SysUtil.updateProperties(sysConfigFile, key, value);
    }

    public static String getProperties(String filePath, String key) {
        Properties prop = SysUtil.getProperties(filePath);
        return prop.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateProperties(String filePath, String key, String value) {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(filePath);
            SafeProperties safeProp = new SafeProperties();
            safeProp.load(input);
            safeProp.setProperty(key, value);
            output = new FileOutputStream(filePath);
            safeProp.store(output);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LogUtil.error("Failed to update configuration." + sw.toString());
            int n = -1;
            return n;
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
                if (null != output) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateProperties1(String filePath, String key, String value) {
        Properties prop = SysUtil.getProperties(filePath);
        prop.setProperty(key, value);
        FileOutputStream oFile = null;
        try {
            oFile = new FileOutputStream(filePath);
            prop.store(oFile, "");
        }
        catch (IOException e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LogUtil.error("Failed to update configuration." + sw.toString());
            int n = -1;
            return n;
        }
        finally {
            try {
                oFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static Properties getProperties(String filePath) {
        if (prop == null) {
            prop = new Properties();
            try {
                BufferedInputStream InputStream2 = new BufferedInputStream(new FileInputStream(new File(filePath)));
                prop.load(InputStream2);
            }
            catch (Exception e) {
                LogUtil.error("read config file error: " + filePath);
            }
        }
        return prop;
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().indexOf("win") >= 0;
    }

    private static void createConfig(String fileName) {
        try {
            SafeProperties pro = new SafeProperties();
            pro.setProperty("svs.service.addrs", "", "Example:127.1.1.1:5000,svs.koal.com:5000");
            pro.setProperty("svs.service.name", "default", "");
            pro.setProperty("svs.service.verify.cert.flag", "true", "Whether to verify the certificate");
            pro.setProperty("svs.service.allow.list.flag", "true", "Whether to verify the allow list");
            pro.setProperty("svs.service.chain.flag", "true", "Whether to verify the chain");
            pro.setProperty("svs.service.valid.flag", "true", "Whether to verify valid");
            pro.setProperty("svs.service.crl.flag", "true", "Whether to verify crl");
            pro.setProperty("koalii-client.ribbon.NFLoadBalancerPingClassName", "com.koalii.svs.client.util.loadbalancer.KoalPingUrl");
            pro.setProperty("koalii-client.ribbon.NFLoadBalancerPingInterval", "60");
            pro.setProperty("koalii-client.ribbon.NFLoadBalancerRuleClassName", "com.koalii.svs.client.util.loadbalancer.KoalRoundRobinRule");
            pro.store(FileUtil.openOutputStream(new File(fileName)));
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LogUtil.error("Failed to update configuration." + sw.toString());
        }
    }
}

