/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client.util.loadbalancer;

import com.koalii.kgsp.core.util.LogUtil;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class KoalRoundRobinRule
extends AbstractLoadBalancerRule {
    private AtomicInteger nextServerCyclicCounter = new AtomicInteger(0);

    public KoalRoundRobinRule() {
    }

    public KoalRoundRobinRule(ILoadBalancer lb) {
        this();
        this.setLoadBalancer(lb);
    }

    public Server choose(ILoadBalancer lb, Object key) {
        if (lb == null) {
            LogUtil.warn("no load balancer");
            return null;
        }
        Server server = null;
        int count = 0;
        while (server == null && count++ < 10) {
            List reachableServers = lb.getReachableServers();
            int upCount = reachableServers.size();
            if (upCount != 0) {
                int nextServerIndex = this.incrementAndGetModulo(upCount);
                server = (Server)reachableServers.get(nextServerIndex);
                LogUtil.debug("reachableServer==>" + server.toString() + ",isAlive==>" + server.isAlive());
                if (server.isAlive() && server.isReadyToServe()) {
                    return server;
                }
                server = null;
                continue;
            }
            LogUtil.warn("No up servers available from load balancer: " + lb);
            return null;
        }
        if (count >= 10) {
            LogUtil.warn("No available alive servers after 10 tries from load balancer: " + lb);
        }
        return server;
    }

    private int incrementAndGetModulo(int modulo) {
        int next;
        int current;
        while (!this.nextServerCyclicCounter.compareAndSet(current = this.nextServerCyclicCounter.get(), next = (current + 1) % modulo)) {
        }
        return next;
    }

    public Server choose(Object key) {
        return this.choose(this.getLoadBalancer(), key);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }
}

