/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client.util;

import com.alibaba.fastjson.JSONObject;
import com.koalii.kgsp.core.util.LogUtil;
import com.koalii.svs.bss.model.BaseRespModel;
import com.netflix.client.ClientException;
import com.netflix.client.ClientFactory;
import com.netflix.client.ClientRequest;
import com.netflix.client.http.HttpHeaders;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.config.ConfigurationManager;
import com.netflix.niws.client.http.RestClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RibbonTemplate {
    static RibbonTemplate ribbonTemplate;
    RestClient client;

    private RibbonTemplate() {
    }

    public static RibbonTemplate getInstance() {
        if (null == ribbonTemplate) {
            ribbonTemplate = new RibbonTemplate();
        }
        return ribbonTemplate;
    }

    public void loadProperties(String listOfServers) {
        boolean maxAutoRetries = true;
        boolean maxAutoRetriesNextServer = true;
        boolean okToRetryOnAllOperations = true;
        int serverListRefreshInterval = 2000;
        int connectTimeout = 3000;
        int readTimeout = 3000;
        boolean EnablePrimeConnections = true;
        this.loadProperties(1, 1, true, 2000, 3000, 3000, listOfServers, true);
    }

    public void loadProperties(int maxAutoRetries, int maxAutoRetriesNextServer, boolean okToRetryOnAllOperations, int serverListRefreshInterval, int connectTimeout, int readTimeout, String listOfServers, boolean EnablePrimeConnections) {
        Properties properties = new Properties();
        properties.put("koalii-client.ribbon.MaxAutoRetries", (Object)maxAutoRetries);
        properties.put("koalii-client.ribbon.MaxAutoRetriesNextServer", (Object)maxAutoRetriesNextServer);
        properties.put("koalii-client.ribbon.OkToRetryOnAllOperations", (Object)okToRetryOnAllOperations);
        properties.put("koalii-client.ribbon.ServerListRefreshInterval", (Object)serverListRefreshInterval);
        properties.put("koalii-client.ribbon.ConnectTimeout", (Object)connectTimeout);
        properties.put("koalii-client.ribbon.ReadTimeout", (Object)readTimeout);
        properties.put("koalii-client.ribbon.listOfServers", listOfServers);
        properties.put("koalii-client.ribbon.EnablePrimeConnections", (Object)EnablePrimeConnections);
        ConfigurationManager.loadProperties((Properties)properties);
        this.client = (RestClient)ClientFactory.getNamedClient((String)"koalii-client");
    }

    public void loadProperties(Properties properties) {
        ConfigurationManager.loadProperties((Properties)properties);
        this.client = (RestClient)ClientFactory.getNamedClient((String)"koalii-client");
    }

    public void loadPropertiesFromResources(String propertiesName) throws IOException {
        ConfigurationManager.loadPropertiesFromResources((String)propertiesName);
        this.client = (RestClient)ClientFactory.getNamedClient((String)propertiesName.split("[.]")[0]);
    }

    public <T> T getForParams(String uri, Map<String, String> params, Class<T> responseType) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            builder.verb(HttpRequest.Verb.GET);
            builder.uri(new URI(uri));
            for (String key : params.keySet()) {
                builder.queryParam(key, params.get(key));
            }
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request);
            return (T)response.getEntity(responseType);
        }
        catch (URISyntaxException urle) {
            urle.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T postForParams(String uri, Map<String, String> params, Class<T> responseType) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            builder.verb(HttpRequest.Verb.POST);
            builder.uri(new URI(uri));
            for (String key : params.keySet()) {
                builder.queryParam(key, params.get(key));
            }
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request);
            return (T)response.getEntity(responseType);
        }
        catch (URISyntaxException urle) {
            urle.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T postForEntity(String uri, Object entity, Class<T> responseType) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            builder.verb(HttpRequest.Verb.POST);
            builder.uri(new URI(uri));
            builder.entity(entity);
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request);
            return (T)response.getEntity(responseType);
        }
        catch (URISyntaxException urle) {
            urle.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T putForParams(String uri, Map<String, String> params, Class<T> responseType) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            builder.verb(HttpRequest.Verb.PUT);
            builder.uri(new URI(uri));
            for (String key : params.keySet()) {
                builder.queryParam(key, params.get(key));
            }
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request);
            return (T)response.getEntity(responseType);
        }
        catch (URISyntaxException urle) {
            urle.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T putForEntity(String uri, Object entity, Class<T> responseType) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            builder.verb(HttpRequest.Verb.PUT);
            builder.uri(new URI(uri));
            builder.entity(entity);
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request);
            return (T)response.getEntity(responseType);
        }
        catch (URISyntaxException urle) {
            urle.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T deleteForParams(String uri, Map<String, String> params, Class<T> responseType) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            builder.verb(HttpRequest.Verb.DELETE);
            builder.uri(new URI(uri));
            for (String key : params.keySet()) {
                builder.queryParam(key, params.get(key));
            }
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request);
            return (T)response.getEntity(responseType);
        }
        catch (URISyntaxException urle) {
            urle.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public JSONObject postForJSONObject(String uri, JSONObject entity, Map<String, String> headers) {
        BaseRespModel brm = new BaseRespModel();
        try {
            LogUtil.info("request uri: " + uri);
            LogUtil.info("request entity: " + entity.toString());
            HttpRequest.Builder builder = HttpRequest.newBuilder();
            builder.verb(HttpRequest.Verb.POST);
            builder.uri(new URI(uri));
            builder.entity((Object)entity);
            if (headers != null && headers.size() != 0) {
                for (String name : headers.keySet()) {
                    builder.header(name, headers.get(name));
                }
            } else {
                builder.header("Content-Type", "application/json;charset=utf-8");
            }
            HttpRequest request = builder.build();
            HttpResponse response = (HttpResponse)this.client.executeWithLoadBalancer((ClientRequest)request);
            StringBuffer logBuffer = new StringBuffer();
            this.recordRespLog(response, logBuffer);
            int status = response.getStatus();
            LogUtil.info("response headers: " + logBuffer.toString());
            if (status == 200) {
                String respEntity = (String)response.getEntity(String.class);
                LogUtil.info("response entity: " + respEntity);
                return JSONObject.parseObject((String)respEntity);
            }
            brm.setErrorCode(1211);
        }
        catch (URISyntaxException urle) {
            LogUtil.error("request uri error: " + uri + ";" + urle.getMessage());
            brm.setErrorCode(1212);
            brm.setMessage(urle.getMessage());
        }
        catch (ClientException ce) {
            LogUtil.error("client executeWithLoadBalancer error:" + ce.getErrorMessage());
            brm.setErrorCode(1213);
            brm.setMessage(ce.getErrorMessage());
        }
        catch (Exception e) {
            LogUtil.error("response parse error:" + e.getMessage());
            brm.setErrorCode(1214);
            brm.setMessage(e.getMessage());
        }
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)brm));
    }

    public StringBuffer recordRespLog(HttpResponse response, StringBuffer logBuffer) {
        HttpHeaders httpHeaders = response.getHttpHeaders();
        List allHeaders = httpHeaders.getAllHeaders();
        for (Map.Entry a : allHeaders) {
            logBuffer.append("\n" + (String)a.getKey() + ":" + (String)a.getValue());
        }
        logBuffer.append("\nresponse-status:" + response.getStatus());
        logBuffer.append("\nresponse-host:" + response.getRequestedURI().getHost());
        logBuffer.append("\nresponse-port:" + response.getRequestedURI().getPort());
        logBuffer.append("\nresponse-path:" + response.getRequestedURI().getPath());
        logBuffer.append("\nresponse-statusLine:" + response.getStatusLine());
        return logBuffer;
    }
}

