/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client.test;

import com.alibaba.fastjson.JSONObject;
import com.koalii.kgsp.core.util.StringUtil;
import com.koalii.svs.client.Svs2ClientHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public abstract class TestObject {
    protected Scanner m_scanner = new Scanner(System.in);
    protected byte[] m_oriData = null;
    protected String m_oriFile = null;
    protected String m_signFile = null;
    protected String m_certData = null;
    protected String m_signData = null;
    protected String m_certId = null;
    protected String m_envFile = null;
    protected List<String> m_certalias = new ArrayList<String>();
    protected String m_b64EvpData = null;
    protected String m_b64EncData = null;
    protected String strFileNameIn = null;
    protected String strFileNameOut = null;
    protected String fileContentOut = null;
    protected String verifyDetachedResult = null;
    protected Svs2ClientHelper.SvsResultData m_result = null;
    protected int m_digestAlg = -1;
    protected long m_errno = -1L;
    protected String m_b64CipherData = null;
    protected Svs2ClientHelper.Cipher cipher = null;
    protected String cipherKey = null;
    protected String algName = null;
    protected String ciphername = null;
    protected String paddingType = null;
    protected byte[] symcKey = null;
    protected List<String> algNames = new ArrayList<String>();
    protected List<String> paddingTypes = new ArrayList<String>();
    protected Svs2ClientHelper.CertInfo certInfo = null;
    protected String message = null;
    protected String base64Data = null;
    protected String base64Cert = null;
    protected byte[] bcert = null;
    protected String oid = null;
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;

    public abstract String done() throws Exception;

    public abstract void input() throws Exception;

    public abstract void output() throws Exception;

    public void test() throws Exception {
        this.input();
        this.done();
        this.output();
    }

    public String readFile(String filename) throws Exception {
        FileInputStream fin = new FileInputStream(filename);
        int nb = fin.available();
        byte[] b = new byte[nb];
        fin.read(b);
        fin.close();
        return new String(b);
    }

    public String inputData() throws Exception {
        System.out.println("Select data type: ");
        System.out.println("0: data");
        System.out.println("1: file");
        System.out.print("Your Selection: ");
        int type = this.m_scanner.nextInt();
        if (1 == type) {
            System.out.println("File name: ");
            String filename = this.m_scanner.next();
            return this.readFile(filename);
        }
        System.out.println("Data: ");
        String s = this.m_scanner.next();
        return s;
    }

    public void inputOriData() throws Exception {
        this.m_oriData = null;
        this.m_oriFile = null;
        System.out.println("Please input origin data:");
        System.out.println("Select data type: ");
        System.out.println("0: data");
        System.out.println("1: file");
        System.out.print("Your Selection: ");
        int type = this.m_scanner.nextInt();
        if (1 == type) {
            System.out.println("File name: ");
            this.m_oriFile = this.m_scanner.next();
            this.m_oriData = this.readFile(this.m_oriFile).getBytes(Charset.forName("UTF-8"));
        } else {
            System.out.println("Data: ");
            this.m_oriData = this.m_scanner.next().getBytes(Charset.forName("UTF-8"));
        }
        System.out.println();
    }

    public void inputStreamAndOutputStream() throws Exception {
        System.out.println("Input file name: ");
        this.m_oriFile = this.m_scanner.next();
        this.inputStream = new FileInputStream(this.m_oriFile);
        System.out.println();
        System.out.println("Output file name: ");
        this.m_oriFile = this.m_scanner.next();
        this.outputStream = new FileOutputStream(this.m_oriFile);
        System.out.println();
    }

    public void inputOriDataStream() throws Exception {
        this.m_oriData = null;
        this.m_oriFile = null;
        System.out.println("Please input origin data:");
        System.out.println("Select data type: ");
        System.out.println("0: data");
        System.out.println("1: file");
        System.out.print("Your Selection: ");
        int type = this.m_scanner.nextInt();
        if (1 == type) {
            this.inputStreamAndOutputStream();
        } else {
            System.out.println("Data: ");
            this.m_oriData = this.m_scanner.next().getBytes(Charset.forName("UTF-8"));
            System.out.println();
        }
    }

    public void inputBase64Data() throws Exception {
        System.out.println("Please input data(base64):");
        this.base64Data = this.inputData();
        System.out.println();
    }

    public void inputBase64P7Data() throws Exception {
        System.out.println("Please input p7Data(base64):");
        this.base64Data = this.inputData();
        System.out.println();
    }

    public void inputBase64Cert() throws Exception {
        System.out.println("Please input cert(base64):");
        this.base64Cert = this.inputData();
        System.out.println();
    }

    public void inputPkcs7SignData() throws Exception {
        System.out.println("Please input pkcs7SignData(base64):");
        this.base64Data = this.inputData();
        System.out.println();
    }

    public void inputCertAlias() throws Exception {
        System.out.println("Please input certAlias:");
        this.m_certalias.add(this.inputData());
        System.out.println();
    }

    public void inputDigestAlg() throws Exception {
        System.out.println("Please input digestAlg :");
        System.out.println("1 : MD5");
        System.out.println("2 : SHA-1");
        System.out.println("3 : SHA-256");
        System.out.println("4 : SHA-512");
        System.out.println("5 : SM3");
        System.out.print("Your selection:");
        this.m_digestAlg = this.m_scanner.nextInt();
        System.out.println();
    }

    public void inputCertData() throws Exception {
        System.out.println("Please input base64 cert:");
        this.m_certData = this.inputData();
        System.out.println();
    }

    public void inputSignData() throws Exception {
        System.out.println("Please input sign data:");
        this.m_signData = this.inputData();
        System.out.println();
    }

    public void inputEvpData() throws Exception {
        System.out.println("Please input evp data(base64):");
        this.m_b64EvpData = this.inputData();
        System.out.println();
    }

    public void inputEncData() throws Exception {
        System.out.println("Please input Enc data(base64):");
        this.m_b64EncData = this.inputData();
        System.out.println();
    }

    public void inputSymcKey() throws Exception {
        if (!this.inputYesOrNo("symcKey")) {
            return;
        }
        System.out.println("Please input symcKey(base64):");
        this.symcKey = Svs2ClientHelper.base64Decode(this.inputData().getBytes());
        System.out.println();
    }

    public void inputOidData() throws Exception {
        System.out.println("Please input oid:");
        this.oid = this.inputData();
        System.out.println();
    }

    public void inputAlgName() throws Exception {
        System.out.println("Please input alg name:");
        System.out.println("1 : 3DES_CBC");
        System.out.println("2 : SM4_CBC");
        System.out.print("Your Selection: ");
        int select = this.m_scanner.nextInt();
        switch (select) {
            case 1: {
                this.algName = "3DES_CBC";
                break;
            }
            case 2: {
                this.algName = "SM4_CBC";
                break;
            }
        }
        System.out.println();
    }

    public void inputCertAlgName() throws Exception {
        System.out.println("Please input cert alg name:");
        System.out.println("1 : DN");
        System.out.println("2 : CN");
        System.out.println("3 : SN");
        System.out.println("4 : SN_HEX");
        System.out.println("5 : ISSUER");
        System.out.println("6 : START");
        System.out.println("7 : END");
        System.out.print("Your Selection: ");
        int select = this.m_scanner.nextInt();
        switch (select) {
            case 1: {
                this.algName = "DN";
                break;
            }
            case 2: {
                this.algName = "CN";
                break;
            }
            case 3: {
                this.algName = "SN";
                break;
            }
            case 4: {
                this.algName = "SN_HEX";
                break;
            }
            case 5: {
                this.algName = "ISSUER";
                break;
            }
            case 6: {
                this.algName = "START";
                break;
            }
            case 7: {
                this.algName = "END";
                break;
            }
        }
        System.out.println();
    }

    public boolean inputYesOrNo(String obj) {
        System.out.println("Pass in a " + obj + " or not:");
        System.out.println("1 : yes");
        System.out.println("0 : no");
        System.out.print("Your Selection: ");
        boolean flag = false;
        int select = this.m_scanner.nextInt();
        switch (select) {
            case 1: {
                flag = true;
                break;
            }
            case 0: {
                flag = false;
                break;
            }
        }
        System.out.println();
        return flag;
    }

    public void inputPaddingType() throws Exception {
        if (!this.inputYesOrNo("padding type")) {
            return;
        }
        System.out.println("Please input padding type:");
        System.out.println("1 : PADDING_ZERO");
        System.out.println("2 : PADDING_PKCS7");
        System.out.print("Your Selection: ");
        int select = this.m_scanner.nextInt();
        switch (select) {
            case 1: {
                this.paddingType = "PADDING_ZERO";
                break;
            }
            case 2: {
                this.paddingType = "PADDING_PKCS7";
                break;
            }
        }
        System.out.println();
    }

    public void inputCipher() throws Exception {
        this.inputAlgName();
        this.inputPaddingType();
        Svs2ClientHelper helper = new Svs2ClientHelper();
        this.cipher = null == this.paddingType ? helper.newCipher(this.algName) : helper.newCipher(this.algName, this.paddingType);
        if (null == this.cipher) {
            System.out.println("cipher is null");
            return;
        }
        this.cipher.name = this.algName;
        this.m_b64CipherData = new String(this.cipher.encode());
        System.out.println();
    }

    public void inputB64EncData() throws Exception {
        System.out.println("Please input enc data(base64):");
        this.m_b64EncData = this.inputData();
        System.out.println();
    }

    public void inputB64EncDataStream() throws Exception {
        System.out.println("Please input enc data:");
        System.out.println("Select data type: ");
        System.out.println("0: data");
        System.out.println("1: file");
        System.out.print("Your Selection: ");
        int type = this.m_scanner.nextInt();
        if (1 == type) {
            this.inputStreamAndOutputStream();
        } else {
            System.out.println("Data(base64): ");
            this.m_b64EncData = this.inputData();
            System.out.println();
        }
    }

    public void inputB64EvpData() throws Exception {
        System.out.println("Please input enp data(base64):");
        this.m_b64EvpData = this.inputData();
        System.out.println();
    }

    public void inputCiphername() throws Exception {
        System.out.println("Please input cipher name:");
        this.ciphername = this.inputData();
        System.out.println();
    }

    public void inputB64CipherData() throws Exception {
        System.out.println("Please input cipher data(base64):");
        this.m_b64CipherData = this.inputData();
        System.out.println();
    }

    public void inputStrFileNameIn() throws Exception {
        System.out.println("Please input origin file path[large file|input] ,next please select 'data':");
        this.strFileNameIn = this.inputData();
        System.out.println();
    }

    public void inputStrFileNameOut() throws Exception {
        System.out.println("Please input sign result path[large file|input or output] ,next please select 'data':");
        this.strFileNameOut = this.inputData();
        if (null != this.strFileNameOut && new File(this.strFileNameOut).exists()) {
            this.fileContentOut = this.readFile(this.strFileNameOut);
        }
        System.out.println();
    }

    public void inputVerifyDetachedResult() throws Exception {
        System.out.println("Please input verifyDetachedResult file path[large file|output] ,next please select 'data':");
        this.verifyDetachedResult = this.inputData();
        System.out.println();
    }

    public void outputResult() throws Exception {
        this.outputResultData();
        if (null != this.m_b64EvpData && !"".equals(this.m_b64EvpData)) {
            System.out.println("Evp Data(base64):" + this.m_b64EvpData);
        }
        if (null != this.m_b64EncData && !"".equals(this.m_b64EvpData)) {
            System.out.println("enc data:" + this.m_b64EncData);
        }
        if (null != this.m_b64CipherData && !"".equals(this.m_b64CipherData)) {
            System.out.println("cipher data:" + this.m_b64CipherData);
        }
        if (null != this.strFileNameOut && !"".equals(this.strFileNameOut)) {
            System.out.println("output file path:" + this.strFileNameOut);
        }
        if (null != this.verifyDetachedResult && !"".equals(this.verifyDetachedResult)) {
            System.out.println("output verifyDetachedResult file path:" + this.verifyDetachedResult);
        }
    }

    public void outputResultData() throws Exception {
        String data;
        if (null == this.m_result) {
            return;
        }
        Object obj = this.m_result.m_errno;
        if (StringUtil.isNotNull(obj)) {
            System.out.println("errno:" + obj);
        }
        if (StringUtil.isNotNull(obj = Integer.valueOf(this.m_result.m_certCnt)) && 0 != (Integer)obj) {
            System.out.println("certCnt:" + obj);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_b64Cert)) {
            System.out.println("b64Cert:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_b64CipherData)) {
            System.out.println("b64CipherData:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_b64EncData)) {
            System.out.println("b64EncData:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_b64EvpData)) {
            System.out.println("b64EvpData:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_b64SignedData)) {
            System.out.println("b64SignedData:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_decryptData)) {
            System.out.println("data:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_digestAlg)) {
            System.out.println("digestAlg:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_encryptData)) {
            System.out.println("encryptData:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_message)) {
            System.out.println("message:" + data);
        }
        if (StringUtil.isNotEmpty(data = this.m_result.m_signAlg)) {
            System.out.println("signAlg:" + data);
        }
        if (StringUtil.isNotNull(obj = this.m_result.m_certs)) {
            System.out.println("certAlias:" + obj.toString());
        }
        if (StringUtil.isNotNull(obj = this.m_result.m_certDns)) {
            System.out.println("certDns:" + obj.toString());
        }
        if (StringUtil.isNotNull(obj = this.m_result.m_certAlias)) {
            System.out.println("certAlias:" + obj.toString());
        }
        if (StringUtil.isNotNull(obj = (Object)this.m_result.m_originData)) {
            System.out.println("originData:" + new String((byte[])obj));
        }
    }

    public void outputCipher() throws Exception {
        if (null != this.cipher) {
            System.out.println("cipher data:" + this.cipher.toString());
        }
        if (null != this.cipherKey && !"".equals(this.cipherKey)) {
            System.out.println("ori cipher key:" + this.cipherKey);
        }
    }

    public void outputMessage() throws Exception {
        if (null != this.message) {
            System.out.println("result:" + this.message);
        }
    }

    public void outputCertInfo() throws Exception {
        if (null != this.certInfo) {
            System.out.println(JSONObject.toJSONString((Object)this.certInfo));
        }
    }
}

