/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client.test;

import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.svs.client.test.Base64DecodeTest;
import com.koalii.svs.client.test.Base64EncodeTest;
import com.koalii.svs.client.test.CdbGetSignCertTest;
import com.koalii.svs.client.test.CdbGetVerifyCertTest;
import com.koalii.svs.client.test.CdbPkcs7DetachSignExTest;
import com.koalii.svs.client.test.CdbPkcs7DetachVerifyExTest;
import com.koalii.svs.client.test.CdbPkcs7DetachVerifyOfHistoryTest;
import com.koalii.svs.client.test.CdbPkcs7EvpDecryptTest;
import com.koalii.svs.client.test.CdbPkcs7EvpEncryptTest;
import com.koalii.svs.client.test.CdbPkcs7SignTest;
import com.koalii.svs.client.test.CdbPkcs7VerifyAndOriDataTest;
import com.koalii.svs.client.test.CdbPkcs7VerifyOfHistoryTest;
import com.koalii.svs.client.test.CdbPkcs7VerifyTest;
import com.koalii.svs.client.test.CdbSignDataTest;
import com.koalii.svs.client.test.CdbVerifySignTest;
import com.koalii.svs.client.test.CipherDecryptTest;
import com.koalii.svs.client.test.CipherEncryptTest;
import com.koalii.svs.client.test.DigestTest;
import com.koalii.svs.client.test.NewCipherTest;
import com.koalii.svs.client.test.ParsePkcs7SignTest;
import com.koalii.svs.client.test.ParseX509CertTest;
import com.koalii.svs.client.test.PrivateKeyDecryptTest;
import com.koalii.svs.client.test.SM3WithSM2DigestTest;
import com.koalii.svs.client.test.TestObject;
import com.koalii.svs.client.test.parseX509CertExtensionByOidTest;
import com.koalii.svs.client.test.publicKeyEncryptTest;
import java.util.ArrayList;
import java.util.Scanner;

class SvsClientTest
extends Thread {
    private static Scanner m_scanner = new Scanner(System.in);
    private static Svs2ClientHelper m_helper = null;
    private static String m_ip = null;
    private static int m_port = 0;
    private static ArrayList<TestCase> testCase = new ArrayList();
    private static int m_ntotal = 0;
    private static long m_start = 0L;
    private static long m_last = 0L;
    private TestObject m_testObj = null;
    private int m_requests = 0;

    public SvsClientTest(TestObject obj, int nreqs) {
        this.m_testObj = obj;
        this.m_requests = nreqs;
    }

    @Override
    public void run() {
        if (null == this.m_testObj) {
            return;
        }
        String nresult = "";
        int i = 0;
        while (0 == this.m_requests || i < this.m_requests) {
            try {
                nresult = this.m_testObj.done();
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
            if ("".equals(nresult)) {
                System.out.println("Error: " + nresult);
            }
            SvsClientTest.total();
            if (0 == this.m_requests) continue;
            ++i;
        }
    }

    public static void lastElapse() {
        long current = System.currentTimeMillis();
        long elapse = current - m_last;
        float avg = 1000.0f / ((float)elapse / 1000.0f);
        System.out.println("Total " + m_ntotal + ", Last elapse " + elapse + "ms, Avg " + avg + "tps");
        m_last = current;
    }

    public static void totalElapse() {
        long current = System.currentTimeMillis();
        long elapse = current - m_start;
        float avg = (float)m_ntotal / ((float)elapse / 1000.0f);
        System.out.println("Total " + m_ntotal + ", total elapse " + elapse + "ms, Avg " + avg + "tps");
    }

    public static synchronized void total() {
        if (0 == ++m_ntotal % 1000) {
            SvsClientTest.lastElapse();
        }
    }

    public static String inputSelect() throws Exception {
        int i = 0;
        String[] name = new String[testCase.size()];
        System.out.println("Please input your selection: ");
        for (i = 0; i < testCase.size(); ++i) {
            TestCase c = testCase.get(i);
            System.out.println("[" + i + "] " + c.m_name);
            name[i] = c.m_class;
        }
        System.out.print("Your selection: ");
        int select = m_scanner.nextInt();
        if (select < 0 || select >= testCase.size()) {
            System.out.println("Invalid selection!");
            return null;
        }
        if (name[select].equalsIgnoreCase("stop")) {
            System.exit(1);
        }
        System.out.println();
        System.out.println("=== Start " + name[select] + " Test ===");
        return name[select];
    }

    public static void inputConnect() throws Exception {
        System.out.print("Please input svs host ip: ");
        m_ip = m_scanner.next();
        System.out.print("Please input svs host port: ");
        m_port = m_scanner.nextInt();
        System.out.println();
    }

    public static void connect() throws Exception {
        if (null == m_helper) {
            m_helper = new Svs2ClientHelper();
            SvsClientTest.inputConnect();
            m_helper.init(m_ip, String.valueOf(m_port), "30");
            System.out.print("Is using log file(Y/N): ");
            String s = m_scanner.next();
            if ('Y' == s.charAt(0) || 'y' == s.charAt(0)) {
                System.out.println("Please input log filename (with full path):");
                String f = m_scanner.next();
                m_helper.setLogFile(f);
            }
            System.out.println();
        }
    }

    public static void singleTest() throws Exception {
        boolean iscontinue = true;
        SvsClientTest.connect();
        while (iscontinue) {
            String name = SvsClientTest.inputSelect();
            if (null == name) continue;
            TestObject obj = (TestObject)Class.forName(name).newInstance();
            obj.test();
            System.out.println();
            System.out.print("Continue? (Y/N): ");
            String s = m_scanner.next();
            if ('N' == s.charAt(0) || 'n' == s.charAt(0)) {
                iscontinue = false;
            }
            System.out.println();
        }
    }

    public static void multiTest() throws Exception {
        boolean iscontinue = true;
        SvsClientTest.connect();
        while (iscontinue) {
            String name = SvsClientTest.inputSelect();
            if (null == name) continue;
            TestObject tobj = (TestObject)Class.forName(name).newInstance();
            tobj.input();
            System.out.print("Please input the thread num (1-200): ");
            int nthreads = m_scanner.nextInt();
            System.out.print("Please input the test num per thread (0 for unlimit): ");
            int nreqs = m_scanner.nextInt();
            SvsClientTest[] cases = new SvsClientTest[nthreads];
            m_start = m_last = System.currentTimeMillis();
            m_ntotal = 0;
            for (int i = 0; i < nthreads; ++i) {
                cases[i] = new SvsClientTest(tobj, nreqs);
                cases[i].start();
            }
            for (int j = 0; j < nthreads; ++j) {
                cases[j].join();
            }
            System.out.println();
            SvsClientTest.totalElapse();
            System.out.print("Continue? (Y/N): ");
            String s = m_scanner.next();
            if ('N' == s.charAt(0) || 'n' == s.charAt(0)) {
                iscontinue = false;
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Welcom to svs client java api test, current vertion is " + Svs2ClientHelper.version());
        System.out.println("Please input test mode:");
        System.out.println("[1]: function test");
        System.out.println("[2]: concurrency test");
        System.out.print("Your selection: ");
        int nselect = m_scanner.nextInt();
        System.out.println();
        switch (nselect) {
            case 1: {
                SvsClientTest.singleTest();
                break;
            }
            case 2: {
                SvsClientTest.multiTest();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                System.out.println("Invalid selection! Exit!");
            }
        }
    }

    static {
        testCase.add(new TestCase("Stop", "Stop"));
        testCase.add(new TestCase("CdbSignDataTest", CdbSignDataTest.class.getName()));
        testCase.add(new TestCase("CdbVerifySignTest", CdbVerifySignTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7SignTest", CdbPkcs7SignTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7VerifyTest", CdbPkcs7VerifyTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7VerifyAndOriDataTest", CdbPkcs7VerifyAndOriDataTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7VerifyOfHistoryTest", CdbPkcs7VerifyOfHistoryTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7DetachSignExTest", CdbPkcs7DetachSignExTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7DetachVerifyExTest", CdbPkcs7DetachVerifyExTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7DetachVerifyOfHistoryTest", CdbPkcs7DetachVerifyOfHistoryTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7EvpEncryptTest", CdbPkcs7EvpEncryptTest.class.getName()));
        testCase.add(new TestCase("CdbPkcs7EvpDecryptTest", CdbPkcs7EvpDecryptTest.class.getName()));
        testCase.add(new TestCase("CdbGetVerifyCertTest", CdbGetVerifyCertTest.class.getName()));
        testCase.add(new TestCase("CdbGetSignCertTest", CdbGetSignCertTest.class.getName()));
        testCase.add(new TestCase("NewCipherTest", NewCipherTest.class.getName()));
        testCase.add(new TestCase("CipherEncryptTest", CipherEncryptTest.class.getName()));
        testCase.add(new TestCase("CipherDecryptTest", CipherDecryptTest.class.getName()));
        testCase.add(new TestCase("publicKeyEncryptTest", publicKeyEncryptTest.class.getName()));
        testCase.add(new TestCase("PrivateKeyDecryptTest", PrivateKeyDecryptTest.class.getName()));
        testCase.add(new TestCase("Base64EncodeTest", Base64EncodeTest.class.getName()));
        testCase.add(new TestCase("Base64DecodeTest", Base64DecodeTest.class.getName()));
        testCase.add(new TestCase("ParseX509CertTest", ParseX509CertTest.class.getName()));
        testCase.add(new TestCase("parseX509CertExtensionByOidTest", parseX509CertExtensionByOidTest.class.getName()));
        testCase.add(new TestCase("ParsePkcs7SignTest", ParsePkcs7SignTest.class.getName()));
        testCase.add(new TestCase("DigestTest", DigestTest.class.getName()));
        testCase.add(new TestCase("SM3WithSM2DigestTest", SM3WithSM2DigestTest.class.getName()));
    }

    protected static class TestCase {
        public String m_name;
        public String m_class;

        public TestCase(String name, String classname) {
            this.m_name = name;
            this.m_class = classname;
        }
    }
}

