/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client.rest;

import com.alibaba.fastjson.JSONObject;
import com.koalii.kgsp.core.util.LogUtil;
import com.koalii.kgsp.core.util.StringUtil;
import com.koalii.svs.bss.model.DecryptDataReqModel;
import com.koalii.svs.bss.model.EncryptDataReqModel;
import com.koalii.svs.bss.model.ExportAllowListCertReqModel;
import com.koalii.svs.bss.model.ExportMyCertReqModel;
import com.koalii.svs.bss.model.RawDecryptReqModel;
import com.koalii.svs.bss.model.RawEncryptReqModel;
import com.koalii.svs.bss.model.SignDataReqModel;
import com.koalii.svs.bss.model.VerifySignedDataReqModel;
import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.svs.client.util.RibbonTemplate;
import com.koalii.util.SysUtil;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class BssTemplate {
    private static final String SIGN_DATA_PATH = "/api/svs/bss/signData";
    private static final String VERIFY_SIGNED_DATA_PATH = "/api/svs/bss/verifySignedData";
    private static final String SIGN_MESSAGE_PATH = "/api/svs/bss/signMessage";
    private static final String VERIFY_SIGNED_MESSAGE_PATH = "/api/svs/bss/verifySignedMessage";
    private static final String SIGN_MESSAGE_DETACH_PATH = "/api/svs/bss/signMessageDetach";
    private static final String VERIFY_SIGNED_MESSAGE_DETACH_PATH = "/api/svs/bss/verifySignedMessageDetach";
    private static final String ENCRYPT_DATA_PATH = "/api/svs/bss/encryptData";
    private static final String DECRYPT_DATA_PATH = "/api/svs/bss/decryptData";
    private static final String RAW_ENCRYPT_PATH = "/api/svs/bss/rawEncrypt";
    private static final String RAW_DECRYPT_PATH = "/api/svs/bss/rawDecrypt";
    private static final String GET_VERIFY_CERT = "/api/svs/bss/exportAllowListCert";
    private static final String GET_SIGN_CERT = "/api/svs/bss/exportMyCert";
    RibbonTemplate ribbonTemplate = RibbonTemplate.getInstance();
    private static BssTemplate bssTemplate = null;
    private String contextPath = SysUtil.getSysConfig("svs.server.contextPath");
    private static HashMap<String, String> headers = new HashMap();

    public BssTemplate() {
        headers.put("Content-Type", "application/json;charset=utf-8");
    }

    public HashMap<String, String> getHeaders() {
        return headers;
    }

    public void setHeader(String name, String value) {
        headers.put(name, value);
    }

    public static BssTemplate getInstance() {
        if (null == bssTemplate) {
            bssTemplate = new BssTemplate();
        }
        return bssTemplate;
    }

    public void loadProperties(String listOfServers) {
        Properties properties = SysUtil.getSysProperties();
        properties.setProperty("koalii-client.ribbon.listOfServers", listOfServers);
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do loadProperties");
        Set<Object> keySet = properties.keySet();
        keySet.forEach(k -> LogUtil.info(loghead + "==>" + k + "=" + properties.getProperty((String)k)));
        this.ribbonTemplate.loadProperties(properties);
    }

    private String getPath(String path) {
        if (StringUtil.isEmpty(this.contextPath)) {
            return path;
        }
        return this.contextPath + path;
    }

    public JSONObject signData(SignDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(SIGN_DATA_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject verifySignedData(VerifySignedDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(VERIFY_SIGNED_DATA_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject signMessage(SignDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(SIGN_MESSAGE_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject verifySignedMessage(VerifySignedDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(VERIFY_SIGNED_MESSAGE_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject verifySignedMessageOfhistory(VerifySignedDataReqModel model) {
        model.getVerifyCertOpt().setAllowListFlag(false);
        model.getVerifyCertOpt().setCertValidFlag(false);
        return this.ribbonTemplate.postForJSONObject(this.getPath(VERIFY_SIGNED_MESSAGE_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject signMessageDetach(SignDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(SIGN_MESSAGE_DETACH_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject verifySignedMessageDetach(VerifySignedDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(VERIFY_SIGNED_MESSAGE_DETACH_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject verifySignedMessageDetachOfHistory(VerifySignedDataReqModel model) {
        model.getVerifyCertOpt().setAllowListFlag(false);
        model.getVerifyCertOpt().setCertValidFlag(false);
        return this.ribbonTemplate.postForJSONObject(this.getPath(VERIFY_SIGNED_MESSAGE_DETACH_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject exportAllowListCert(ExportAllowListCertReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(GET_VERIFY_CERT), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject exportMyCert(ExportMyCertReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(GET_SIGN_CERT), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject encryptData(EncryptDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(ENCRYPT_DATA_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject decryptData(DecryptDataReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(DECRYPT_DATA_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject rawEncrypt(RawEncryptReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(RAW_ENCRYPT_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }

    public JSONObject rawDecrypt(RawDecryptReqModel model) {
        return this.ribbonTemplate.postForJSONObject(this.getPath(RAW_DECRYPT_PATH), (JSONObject)JSONObject.toJSON((Object)model), headers);
    }
}

