/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.sock.client;

import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class TcpSockClient {
    public static final int DEFAULT_RECV_TIMEOUT_SEC = 30;
    public static final int DEFAULT_RETRY_TIMES = 5;
    public static final int DEFAULT_RETRY_WAITTIME_SEC = 3;
    private String m_remote_host = null;
    private int m_remote_port = 0;
    private int m_recv_timeout_sec = 30;
    private int m_retry_times = 5;
    private int m_retry_wait_sec = 3;
    private Socket m_sock_fd = null;
    private long m_lastupdate = 0L;
    private boolean m_isbusy = false;

    public TcpSockClient() {
    }

    public TcpSockClient(String host, int port) {
        this.m_remote_host = host;
        this.m_remote_port = port;
    }

    public TcpSockClient(String host, int port, int recv_timeout_sec) {
        this.m_remote_host = host;
        this.m_remote_port = port;
        if (recv_timeout_sec > 0) {
            this.m_recv_timeout_sec = recv_timeout_sec;
        }
    }

    public TcpSockClient(String host, int port, int recv_timeout_sec, int nretry, int retry_wait_sec) {
        this.m_remote_host = host;
        this.m_remote_port = port;
        if (recv_timeout_sec > 0) {
            this.m_recv_timeout_sec = recv_timeout_sec;
        }
        if (nretry > 0) {
            this.m_retry_times = nretry;
        }
        if (retry_wait_sec >= 0) {
            this.m_retry_wait_sec = retry_wait_sec;
        }
    }

    public void open() throws KcException {
        if (null == this.m_sock_fd || this.m_sock_fd.isClosed()) {
            try {
                LogUtil.info(this.toString() + ": starting connect");
                this.m_sock_fd = new Socket();
                this.m_sock_fd.connect(new InetSocketAddress(this.m_remote_host, this.m_remote_port), this.m_recv_timeout_sec * 1000);
                this.m_sock_fd.setSoTimeout(this.m_recv_timeout_sec * 1000);
                this.m_lastupdate = System.currentTimeMillis();
                LogUtil.info(this.toString() + ": connect successful");
            }
            catch (Exception e) {
                LogUtil.error(this.toString() + ": connect failed: " + e.getMessage());
                this.close();
                throw new KcException(100211, (Throwable)e);
            }
        }
    }

    public void close() {
        if (null != this.m_sock_fd) {
            String address = this.toString();
            try {
                this.m_sock_fd.close();
                this.m_sock_fd = null;
                LogUtil.info(address + ": closed");
            }
            catch (Exception e) {
                this.m_sock_fd = null;
                LogUtil.error(address + ": close failed: " + e.getMessage());
            }
            this.m_lastupdate = 0L;
        }
    }

    public void close_timeout(int timeout_sec) {
        if (timeout_sec <= 0 || this.m_isbusy || null == this.m_sock_fd || this.m_sock_fd.isClosed() || 0L == this.m_lastupdate) {
            return;
        }
        long current = System.currentTimeMillis();
        if (current > this.m_lastupdate && current - this.m_lastupdate > (long)(timeout_sec * 1000)) {
            LogUtil.info(this.toString() + ": timeout");
            this.close();
        }
    }

    public void send(byte[] data, int offset, int len) throws KcException {
        if (null == data || offset < 0 || offset >= data.length) {
            throw new KcException(100002);
        }
        if (null == this.m_sock_fd || this.m_sock_fd.isClosed()) {
            LogUtil.info(this.toString() + ": opening before send");
            this.open();
        }
        try {
            OutputStream os = this.m_sock_fd.getOutputStream();
            os.write(data, offset, len);
            os.flush();
            this.m_lastupdate = System.currentTimeMillis();
            LogUtil.info(this.toString() + ": sended " + len);
        }
        catch (IOException e) {
            this.m_lastupdate = System.currentTimeMillis();
            LogUtil.error(this.toString() + ": send failed: " + e.getMessage());
            throw new KcException(100212, (Throwable)e);
        }
    }

    protected boolean isEndOf(byte[] data, byte[] end) {
        if (data.length < end.length) {
            return false;
        }
        for (int i = 0; i < end.length; ++i) {
            if (data[data.length - end.length + i] == end[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean isEndOfOmitSpace(byte[] data, byte[] end) {
        int n;
        if (data.length < end.length) {
            return false;
        }
        for (n = data.length; n > 0 && (32 == data[n - 1] || 9 == data[n - 1] || 13 == data[n - 1] || 10 == data[n - 1]); --n) {
        }
        if (n < end.length) {
            return false;
        }
        for (int i = 0; i < end.length; ++i) {
            if (data[n - end.length + i] == end[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] recv(byte[] endMsg) throws KcException {
        if (null == this.m_sock_fd || this.m_sock_fd.isClosed()) {
            throw new KcException(100214);
        }
        int rlen = 0;
        byte[] rdata = new byte[8192];
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        boolean isEnd = false;
        int retry_num = 0;
        try {
            InputStream in = this.m_sock_fd.getInputStream();
            do {
                isEnd = true;
                rlen = in.read(rdata);
                this.m_lastupdate = System.currentTimeMillis();
                LogUtil.info(this.toString() + ": read " + rlen);
                if (-1 == rlen) break;
                if (0 == rlen) {
                    if (++retry_num > 10) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LogUtil.info(this.toString() + ": read 0, retry_num " + retry_num);
                    isEnd = false;
                    continue;
                }
                retry_num = 0;
                buf.write(rdata, 0, rlen);
                LogUtil.info(this.toString() + ": read total read " + buf.size());
                if (null != endMsg) {
                    if (this.isEndOf(buf.toByteArray(), endMsg)) continue;
                    isEnd = false;
                    continue;
                }
                if (rdata.length != rlen) continue;
                isEnd = false;
            } while (!isEnd && retry_num < 30);
        }
        catch (Exception e) {
            this.m_lastupdate = System.currentTimeMillis();
            LogUtil.error(this.toString() + ": read failed: " + e.getMessage());
            throw new KcException(100213, (Throwable)e);
        }
        if (0 == buf.size()) {
            throw new KcException(100213);
        }
        return buf.toByteArray();
    }

    public byte[] sendAndRecv(String data) throws KcException {
        return this.sendAndRecv(data.getBytes(), 0, data.getBytes().length, null);
    }

    public byte[] sendAndRecv(String data, String endMsg) throws KcException {
        return this.sendAndRecv(data.getBytes(), 0, data.getBytes().length, endMsg.getBytes());
    }

    public byte[] sendAndRecv(byte[] data) throws KcException {
        return this.sendAndRecv(data, 0, data.length, null);
    }

    public byte[] sendAndRecv(byte[] data, byte[] endMsg) throws KcException {
        return this.sendAndRecv(data, 0, data.length, endMsg);
    }

    public byte[] sendAndRecv(byte[] data, int offset, int len, byte[] endMsg) throws KcException {
        int maxretry = this.m_retry_times > 0 ? this.m_retry_times : 1;
        byte[] retdata = null;
        String address = "";
        if (null == data || offset < 0 || offset >= data.length) {
            throw new KcException(100002);
        }
        for (int nretry = 0; nretry <= maxretry; ++nretry) {
            try {
                address = this.toString();
                this.send(data, offset, len);
                address = this.toString();
                retdata = this.recv(endMsg);
                return retdata;
            }
            catch (KcException e) {
                this.close();
                if (nretry > 0 && nretry < maxretry && this.m_retry_wait_sec > 0) {
                    LogUtil.warn(address + ": sendAndRecv failed " + e.getErrorNo() + ", retry " + nretry + ", sleep " + this.m_retry_wait_sec + " seconds and try again");
                    try {
                        Thread.sleep(this.m_retry_wait_sec * 1000);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (maxretry == nretry) {
                    LogUtil.error(address + ": sendAndRecv failed " + e.getErrorNo() + ", reached max retry " + nretry);
                    continue;
                }
                LogUtil.warn(address + ": sendAndRecv failed " + e.getErrorNo() + ", retry " + nretry + " and not sleep");
                continue;
            }
        }
        throw new KcException(100215);
    }

    public int getRemotePort() {
        return this.m_remote_port;
    }

    public String getRemoteHost() {
        return this.m_remote_host;
    }

    public void setRemotePort(int i) {
        this.m_remote_port = i;
    }

    public void setIP(String host) {
        this.m_remote_host = host;
    }

    public void setTimeoutSec(int timeout_sec) {
        if (timeout_sec > 0) {
            this.m_recv_timeout_sec = timeout_sec;
        }
    }

    public void setRetry(int nretry, int retry_wait_sec) {
        if (nretry > 0) {
            this.m_retry_times = nretry;
        }
        if (retry_wait_sec >= 0) {
            this.m_retry_wait_sec = retry_wait_sec;
        }
    }

    public int getTimeoutSec() {
        return this.m_retry_times * this.m_retry_wait_sec;
    }

    public String getLocalAddress() {
        if (null == this.m_sock_fd || this.m_sock_fd.isClosed()) {
            return "";
        }
        return this.m_sock_fd.getLocalAddress().getHostAddress() + ":" + this.m_sock_fd.getLocalPort();
    }

    public void setBusy(boolean isbusy) {
        this.m_isbusy = isbusy;
    }

    public boolean isBusy() {
        return this.m_isbusy;
    }

    public boolean isClosed() {
        if (null == this.m_sock_fd) {
            return true;
        }
        return this.m_sock_fd.isClosed();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (null == this.m_sock_fd) {
            sbuf.append("[sock is null] ");
        } else if (this.m_sock_fd.isClosed()) {
            sbuf.append("[sock is closed] ");
        } else if (!this.m_sock_fd.isConnected()) {
            sbuf.append("[sock is unconnected] ");
        } else {
            sbuf.append("[" + this.getLocalAddress() + "]");
        }
        sbuf.append("[" + this.m_lastupdate + "]");
        if (this.m_isbusy) {
            sbuf.append("[isbusy:1]");
        } else {
            sbuf.append("[isbusy:0]");
        }
        return sbuf.toString();
    }

    public static void main(String[] args) throws Exception {
        byte[] oridata = new byte[81920];
        String b64ori = new String(Base64.encode(oridata));
        StringBuffer req = new StringBuffer();
        req.append("<?xml version=\"1.0\" encoding=\"gb2312\"?>");
        req.append("<msg><msg_head><msg_type>0</msg_type><msg_id>1007</msg_id><msg_sn>0</msg_sn><version>1</version></msg_head><msg_body>");
        req.append("<origin_data_len>");
        req.append(b64ori.length());
        req.append("</origin_data_len>");
        req.append("<origin_data>");
        req.append(b64ori);
        req.append("</origin_data>");
        req.append("</msg_body></msg>");
        TcpSockClient sclient = new TcpSockClient("192.168.171.8", 5000, 10);
        long start = System.currentTimeMillis();
        byte[] resp = null;
        for (int i = 0; i < 50; ++i) {
            resp = sclient.sendAndRecv(req.toString(), new String("</msg>"));
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("recved[" + resp.length + "]: " + new String(resp));
        sclient.close();
        System.out.println(sclient.toString());
    }
}

