/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.sock.client;

import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.sock.client.TcpSockClient;
import com.koalii.kgsp.core.util.LogUtil;

public class SockClientPool {
    private static final int SOCKCLIENTPOOL_MAX_SIZE = 200;
    private static final int SOCKCLIENTPOOL_DEFAULT_SIZE = 30;
    private static final int SOCKCLIENTPOOL_DEFAULT_IDLE_SEC = 300;
    private TcpSockClient[] socks = null;
    private int maxSize = 200;
    private int maxIdleSec = 300;
    private String remoteHost;
    private int remotePort;
    private int timeoutSec;
    private boolean isRetry = false;
    private int retryTimes;
    private int retryWaitSec;

    public synchronized void init(String host, int port, int timeout_sec) {
        int nsize = 30;
        this.socks = new TcpSockClient[nsize];
        for (int i = 0; i < nsize; ++i) {
            this.socks[i] = new TcpSockClient(host, port, timeout_sec);
            if (!this.isRetry) continue;
            this.socks[i].setRetry(this.retryTimes, this.retryWaitSec);
        }
        this.remoteHost = host;
        this.remotePort = port;
        this.timeoutSec = timeout_sec;
    }

    public synchronized void init(String host, int port, int timeout_sec, int nconcurrent) {
        int nsize = 0;
        if (nconcurrent <= 0) {
            nsize = 30;
        } else if (nconcurrent <= 200) {
            nsize = nconcurrent;
        } else {
            nsize = nconcurrent;
            this.maxSize = nconcurrent;
        }
        this.socks = new TcpSockClient[nsize];
        for (int i = 0; i < nsize; ++i) {
            this.socks[i] = new TcpSockClient(host, port, timeout_sec);
            if (!this.isRetry) continue;
            this.socks[i].setRetry(this.retryTimes, this.retryWaitSec);
        }
        this.remoteHost = host;
        this.remotePort = port;
        this.timeoutSec = timeout_sec;
    }

    public synchronized void init(String host, int port, int timeout_sec, int nconcurrent, int nmax_size) {
        int nsize = 0;
        nsize = nconcurrent <= 0 ? 30 : nconcurrent;
        this.socks = new TcpSockClient[nsize];
        for (int i = 0; i < nsize; ++i) {
            this.socks[i] = new TcpSockClient(host, port, timeout_sec);
            if (!this.isRetry) continue;
            this.socks[i].setRetry(this.retryTimes, this.retryWaitSec);
        }
        this.remoteHost = host;
        this.remotePort = port;
        this.timeoutSec = timeout_sec;
        this.maxSize = nmax_size > nconcurrent ? nmax_size : nconcurrent;
    }

    public void setRetry(int nretry, int retry_wait_sec) {
        this.isRetry = true;
        this.retryTimes = nretry;
        this.retryWaitSec = retry_wait_sec;
        if (null != this.socks) {
            int nsize = this.socks.length;
            for (int i = 0; i < nsize; ++i) {
                this.socks[i].setRetry(this.retryTimes, this.retryWaitSec);
            }
        }
    }

    public synchronized void clean() {
        if (null == this.socks) {
            return;
        }
        for (int i = 0; i < this.socks.length; ++i) {
            this.socks[i].close();
            this.socks[i] = null;
        }
        this.socks = null;
    }

    public synchronized void clean_idle() {
        if (null == this.socks || this.maxIdleSec <= 0) {
            return;
        }
        for (int i = 0; i < this.socks.length; ++i) {
            this.socks[i].close_timeout(this.maxIdleSec);
        }
    }

    public synchronized TcpSockClient pop() {
        int i;
        if (null == this.socks) {
            return null;
        }
        this.clean_idle();
        for (int i2 = 0; i2 < this.socks.length; ++i2) {
            if (this.socks[i2].isBusy()) continue;
            this.socks[i2].setBusy(true);
            LogUtil.info(this.toString() + ", poped " + this.socks[i2].toString());
            return this.socks[i2];
        }
        if (this.socks.length >= this.maxSize) {
            LogUtil.info(this.toString() + ", pool is full");
            return null;
        }
        int nsize = this.socks.length * 2 < this.maxSize ? this.socks.length * 2 : this.maxSize;
        TcpSockClient[] tmp = new TcpSockClient[nsize];
        for (i = 0; i < this.socks.length; ++i) {
            tmp[i] = this.socks[i];
        }
        for (i = this.socks.length; i < nsize; ++i) {
            tmp[i] = new TcpSockClient(this.remoteHost, this.remotePort, this.timeoutSec);
            if (!this.isRetry) continue;
            tmp[i].setRetry(this.retryTimes, this.retryWaitSec);
        }
        int nindex = this.socks.length;
        this.socks = tmp;
        this.socks[nindex].setBusy(true);
        LogUtil.info(this.toString() + ", poped " + this.socks[nindex].toString());
        return this.socks[nindex];
    }

    public synchronized void push(TcpSockClient sock) {
        sock.setBusy(false);
        LogUtil.info(this.toString() + ", pushed " + sock.toString());
        this.clean_idle();
    }

    public void setConcurrent(int nconcurrent) {
        this.clean();
        int nsize = 0;
        if (nconcurrent <= 0) {
            nsize = 30;
        } else if (nconcurrent <= 200) {
            nsize = nconcurrent;
            this.maxSize = 200;
        } else {
            nsize = nconcurrent;
            this.maxSize = nconcurrent;
        }
        this.socks = new TcpSockClient[nsize];
        for (int i = 0; i < nsize; ++i) {
            this.socks[i] = new TcpSockClient(this.remoteHost, this.remotePort, this.timeoutSec);
            if (!this.isRetry) continue;
            this.socks[i].setRetry(this.retryTimes, this.retryWaitSec);
        }
    }

    public void setMaxIdleTime(int seconds) {
        this.maxIdleSec = seconds;
    }

    public int getMaxIdleTime() {
        return this.maxIdleSec;
    }

    public synchronized int getBusySize() {
        if (null == this.socks) {
            return 0;
        }
        int nbusy = 0;
        for (int i = 0; i < this.socks.length; ++i) {
            if (!this.socks[i].isBusy()) continue;
            ++nbusy;
        }
        return nbusy;
    }

    public synchronized int getValidSize() {
        if (null == this.socks) {
            return 0;
        }
        int nvalid = 0;
        for (int i = 0; i < this.socks.length; ++i) {
            if (this.socks[i].isClosed()) continue;
            ++nvalid;
        }
        return nvalid;
    }

    public synchronized int getSize() {
        if (null == this.socks) {
            return 0;
        }
        return this.socks.length;
    }

    public synchronized String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (null == this.socks) {
            sbuf.append("[pool is null] ");
            return sbuf.toString();
        }
        sbuf.append("[pool total " + this.getSize() + ", busy " + this.getBusySize() + ", valid " + this.getValidSize() + "]");
        return sbuf.toString();
    }

    public synchronized String toMoreString() {
        StringBuffer sbuf = new StringBuffer();
        if (null == this.socks) {
            sbuf.append("[pool is null] ");
            return sbuf.toString();
        }
        sbuf.append("[pool total " + this.getSize() + ", busy " + this.getBusySize() + ", valid " + this.getValidSize() + "]");
        for (int i = 0; i < this.socks.length; ++i) {
            if (!this.socks[i].isBusy() && this.socks[i].isClosed()) continue;
            if (this.socks[i].isBusy()) {
                sbuf.append("\n[busy]");
            } else {
                sbuf.append("\n[idle]");
            }
            if (this.socks[i].isClosed()) {
                sbuf.append("[closed]");
                continue;
            }
            sbuf.append("[connected]");
            sbuf.append(this.socks[i].toString());
        }
        return sbuf.toString();
    }

    public static void main(String[] args) throws Exception {
        String oridata = "koalii";
        String b64ori = new String(Base64.encode(oridata.getBytes()));
        StringBuffer req = new StringBuffer();
        req.append("<?xml version=\"1.0\" encoding=\"gb2312\"?>");
        req.append("<msg><msg_head><msg_type>0</msg_type><msg_id>1007</msg_id><msg_sn>0</msg_sn><version>1</version></msg_head><msg_body>");
        req.append("<origin_data_len>");
        req.append(b64ori.length());
        req.append("</origin_data_len>");
        req.append("<origin_data>");
        req.append(b64ori);
        req.append("</origin_data>");
        req.append("</msg_body></msg>");
        SockClientPool scpool = new SockClientPool();
        scpool.init("192.168.171.8", 5000, 30, 10);
        System.out.println(scpool.toString());
        byte[] resp = null;
        TcpSockClient sclient = null;
        for (int i = 0; i < 30; ++i) {
            sclient = scpool.pop();
            resp = sclient.sendAndRecv(req.toString());
            System.out.println(scpool.toMoreString());
            scpool.push(sclient);
        }
        System.out.println(scpool.toMoreString());
        scpool.clean();
    }
}

