/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1InputStream;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.ASN1Set;
import com.koalii.kgsp.bc.asn1.cms.Attribute;
import com.koalii.kgsp.bc.asn1.cms.ContentInfo;
import com.koalii.kgsp.bc.asn1.cms.SignedData;
import com.koalii.kgsp.bc.asn1.cms.SignerInfo;
import com.koalii.kgsp.bc.asn1.pkcs.IssuerAndSerialNumber;
import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.Certificate;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Pkcs7SignParser {
    private byte[] oriData;
    private ASN1ObjectIdentifier dataContentType;
    private ASN1ObjectIdentifier contentType;
    private List<Pkcs7SignInfo> signInfos = new ArrayList<Pkcs7SignInfo>();

    public byte[] getOriData() {
        return this.oriData;
    }

    public ASN1ObjectIdentifier getDataContentType() {
        return this.dataContentType;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public List<Pkcs7SignInfo> getSignInfos() {
        return this.signInfos;
    }

    public void parse(byte[] signData) throws KcException {
        this.clear();
        if (null == signData) {
            throw new KcException(100001, "parse p7 sign: sign data is empty");
        }
        if (signData[0] == 77) {
            signData = Base64.decode(signData);
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signData).readObject());
        }
        catch (IOException e) {
            throw new KcException(100159, "parse p7 sign: parse sign data failed", e);
        }
        this.contentType = cinfo.getContentType();
        SignedData sd = SignedData.getInstance(cinfo.getContent());
        ContentInfo dataContent = sd.getEncapContentInfo();
        this.dataContentType = dataContent.getContentType();
        this.oriData = this.parseOriData(dataContent);
        int nsize = sd.getSignerInfos().size();
        SignerInfo sf = null;
        ASN1Set certs = null;
        Pkcs7SignInfo signInfo = null;
        for (int i = 0; i < nsize; ++i) {
            sf = SignerInfo.getInstance(sd.getSignerInfos().getObjectAt(i));
            certs = sd.getCertificates();
            signInfo = new Pkcs7SignInfo(sf);
            if (certs != null) {
                signInfo.setSignCert(this.findSignCert(sf, certs));
            }
            this.signInfos.add(signInfo);
        }
    }

    protected void clear() {
        this.signInfos.clear();
        this.oriData = null;
        this.contentType = null;
        this.dataContentType = null;
    }

    protected byte[] parseOriData(ContentInfo dataContent) {
        ASN1OctetString octets = ASN1OctetString.getInstance(dataContent.getContent());
        return null == octets ? null : octets.getOctets();
    }

    protected X509CertificateHolder findSignCert(SignerInfo sf, ASN1Set certs) throws KcException {
        if (null == certs) {
            return null;
        }
        IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance(sf.getSID().getId());
        X509CertificateHolder certHolder = null;
        Enumeration ec = certs.getObjects();
        while (ec.hasMoreElements()) {
            certHolder = new X509CertificateHolder(Certificate.getInstance(ec.nextElement()));
            if (isn.getCertificateSerialNumber().getValue().equals(certHolder.getSerialNumber()) && isn.getName().equals(certHolder.getIssuer())) break;
            certHolder = null;
        }
        return certHolder;
    }

    public String toString() {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("content-type: " + this.contentType.getId() + "\n");
        sbuffer.append("data-content-type: " + this.dataContentType.getId() + "\n");
        sbuffer.append("oridata: ");
        if (StringUtil.isNotEmpty(this.oriData)) {
            sbuffer.append(new String(this.oriData));
        }
        sbuffer.append("\n");
        return sbuffer.toString();
    }

    public class Pkcs7SignInfo {
        protected X509CertificateHolder signCert;
        protected byte[] signData;
        protected AlgorithmIdentifier digestAid;
        protected AlgorithmIdentifier encryptDigestAid;
        protected byte[] authAttrData;
        protected byte[] oriDigestData;
        protected byte[] unauthAttrData;

        public Pkcs7SignInfo() {
        }

        public Pkcs7SignInfo(SignerInfo sf) throws KcException {
            ASN1Set unauthAttrs;
            this.signData = sf.getEncryptedDigest().getOctets();
            this.digestAid = sf.getDigestAlgorithm();
            this.encryptDigestAid = sf.getDigestEncryptionAlgorithm();
            ASN1Set authAttrs = sf.getAuthenticatedAttributes();
            if (null != authAttrs) {
                int nsize = authAttrs.size();
                Attribute attr = null;
                for (int i = 0; i < nsize; ++i) {
                    attr = Attribute.getInstance(authAttrs.getObjectAt(i));
                    if (!PKCSObjectIdentifiers.pkcs_9_at_messageDigest.equals(attr.getAttrType())) continue;
                    this.oriDigestData = ASN1OctetString.getInstance(attr.getAttributeValues()[0]).getOctets();
                }
                try {
                    this.authAttrData = authAttrs.getEncoded();
                }
                catch (Exception e) {
                    throw new KcException(100150, "parse p7 sign: get auth attrs encode failed");
                }
            }
            if (null != (unauthAttrs = sf.getUnauthenticatedAttributes())) {
                try {
                    this.unauthAttrData = unauthAttrs.getEncoded();
                }
                catch (Exception e) {
                    throw new KcException(100150, "parse p7 sign: get unauth attrs encode failed");
                }
            }
        }

        public void setSignCert(X509CertificateHolder signCert) {
            this.signCert = signCert;
        }

        public void setSignData(byte[] signData) {
            this.signData = signData;
        }

        public void setDigestAid(AlgorithmIdentifier digestAid) {
            this.digestAid = digestAid;
        }

        public void setEncryptDigestAid(AlgorithmIdentifier encryptDigestAid) {
            this.encryptDigestAid = encryptDigestAid;
        }

        public void setAuthAttrData(byte[] authAttrData) {
            this.authAttrData = authAttrData;
        }

        public void setOriDigestData(byte[] oriDigestData) {
            this.oriDigestData = oriDigestData;
        }

        public X509CertificateHolder getSignCert() {
            return this.signCert;
        }

        public byte[] getSignData() {
            return this.signData;
        }

        public AlgorithmIdentifier getDigestAid() {
            return this.digestAid;
        }

        public AlgorithmIdentifier getEncryptDigestAid() {
            return this.encryptDigestAid;
        }

        public byte[] getAuthAttrData() {
            return this.authAttrData;
        }

        public byte[] getOriDigestData() {
            return this.oriDigestData;
        }

        public byte[] getUnauthAttrData() {
            return this.unauthAttrData;
        }

        public void setUnauthAttrData(byte[] unauthAttrData) {
            this.unauthAttrData = unauthAttrData;
        }
    }
}

