/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.ASN1InputStream;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.ASN1Set;
import com.koalii.kgsp.bc.asn1.DEROctetString;
import com.koalii.kgsp.bc.asn1.DERSet;
import com.koalii.kgsp.bc.asn1.cms.CMSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.cms.ContentInfo;
import com.koalii.kgsp.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.kgsp.bc.asn1.cms.SignedData;
import com.koalii.kgsp.bc.asn1.cms.SignerIdentifier;
import com.koalii.kgsp.bc.asn1.cms.SignerInfo;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.core.crypto.KcSigner;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.StringUtil;
import java.io.IOException;

public class Pkcs7SignBuilder {
    public byte[] buildAttach(byte[] oriData, byte[] signData, X509CertificateHolder cert, KcSigner signer) throws KcException {
        return this.build(oriData, signData, cert, signer, false);
    }

    public byte[] buildDetach(byte[] oriData, byte[] signData, X509CertificateHolder cert, KcSigner signer) throws KcException {
        return this.build(oriData, signData, cert, signer, true);
    }

    public byte[] build(byte[] oriData, byte[] signData, X509CertificateHolder cert, KcSigner signer, boolean isDetach) throws KcException {
        if (!isDetach && StringUtil.isEmpty(oriData)) {
            throw new KcException(100153, "p7 sign builder: no origin data");
        }
        if (StringUtil.isEmpty(signData)) {
            throw new KcException(100154, "p7 sign builder: no sign data");
        }
        if (null == cert) {
            throw new KcException(100155, "p7 sign builder: no sign cert");
        }
        if (null == signer) {
            throw new KcException(100156, "p7 sign builder: no signer info");
        }
        ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
        digestAlgorithms.add(signer.getDigestAlgId());
        ASN1EncodableVector certs = new ASN1EncodableVector();
        try {
            certs.add(new ASN1InputStream(cert.getEncoded()).readObject());
        }
        catch (Exception e) {
            throw new KcException(100157, "p7 sign builder: add sign cert failed", e);
        }
        ContentInfo cinfo = null;
        cinfo = isDetach ? new ContentInfo(this.getDataContentType(), null) : new ContentInfo(this.getDataContentType(), new DEROctetString(oriData));
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(cert.getIssuer(), cert.getSerialNumber());
        SignerInfo sinfo = new SignerInfo(new SignerIdentifier(isn), signer.getDigestAlgId(), ASN1Set.getInstance(null), signer.getEncryptAlgId(), (ASN1OctetString)new DEROctetString(signData), null);
        ASN1EncodableVector sinfos = new ASN1EncodableVector();
        sinfos.add(sinfo);
        SignedData sdata = new SignedData(new DERSet(digestAlgorithms), cinfo, new DERSet(certs), null, new DERSet(sinfos));
        ContentInfo p7 = new ContentInfo(this.getContentType(), sdata);
        try {
            return p7.getEncoded("DER");
        }
        catch (IOException e) {
            throw new KcException(100158, "p7 sign build failed", e);
        }
    }

    public byte[] build(byte[] oriData, X509CertificateHolder cert, KcSigner signer, SignerInfo sinfo, boolean isDetach) throws KcException {
        if (!isDetach && StringUtil.isEmpty(oriData)) {
            throw new KcException(100153, "p7 sign builder: no origin data");
        }
        if (null == cert) {
            throw new KcException(100155, "p7 sign builder: no sign cert");
        }
        if (null == signer) {
            throw new KcException(100156, "p7 sign builder: no signer info");
        }
        ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
        digestAlgorithms.add(signer.getDigestAlgId());
        ASN1EncodableVector certs = new ASN1EncodableVector();
        try {
            certs.add(new ASN1InputStream(cert.getEncoded()).readObject());
        }
        catch (Exception e) {
            throw new KcException(100157, "p7 sign builder: add sign cert failed", e);
        }
        ContentInfo cinfo = null;
        cinfo = isDetach ? new ContentInfo(this.getDataContentType(), null) : new ContentInfo(this.getDataContentType(), new DEROctetString(oriData));
        ASN1EncodableVector sinfos = new ASN1EncodableVector();
        sinfos.add(sinfo);
        SignedData sdata = new SignedData(new DERSet(digestAlgorithms), cinfo, new DERSet(certs), null, new DERSet(sinfos));
        ContentInfo p7 = new ContentInfo(this.getContentType(), sdata);
        try {
            return p7.getEncoded("DER");
        }
        catch (IOException e) {
            throw new KcException(100158, "p7 sign build failed", e);
        }
    }

    protected ASN1ObjectIdentifier getContentType() {
        return CMSObjectIdentifiers.signedData;
    }

    protected ASN1ObjectIdentifier getDataContentType() {
        return CMSObjectIdentifiers.data;
    }
}

