/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.ASN1Integer;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.ASN1Set;
import com.koalii.kgsp.bc.asn1.ASN1UTCTime;
import com.koalii.kgsp.bc.asn1.BERSequence;
import com.koalii.kgsp.bc.asn1.BERSet;
import com.koalii.kgsp.bc.asn1.DEROctetString;
import com.koalii.kgsp.bc.asn1.cms.Attribute;
import com.koalii.kgsp.bc.asn1.cms.Attributes;
import com.koalii.kgsp.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.kgsp.bc.asn1.cms.SignerIdentifier;
import com.koalii.kgsp.bc.asn1.cms.SignerInfo;
import com.koalii.kgsp.bc.asn1.oiw.OIWObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.Digest;
import com.koalii.kgsp.bc.operator.DefaultAlgorithmNameFinder;
import com.koalii.kgsp.bc.util.Arrays;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.crypto.KcDigestUtil;
import com.koalii.kgsp.core.crypto.KcSigner;
import com.koalii.kgsp.core.crypto.KcSignerFactory;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.pkcs.Pkcs7SignBuilder;
import com.koalii.kgsp.core.pkcs.Pkcs7SignBuilderFactory;
import com.koalii.kgsp.core.pkcs.Pkcs7SignParser;
import com.koalii.kgsp.core.util.StringUtil;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class Pkcs7Sign {
    private KcCertStore certStore;
    private KcSigner signer;
    private Pkcs7SignBuilder builder;

    public Pkcs7Sign() {
    }

    public Pkcs7Sign(KcCertStore store) {
        this.certStore = store;
    }

    public Pkcs7Sign(KcKeyStore store) {
        this.certStore = store;
    }

    public KcCertStore getCertStore() {
        return this.certStore;
    }

    public void setCertStore(KcCertStore certStore) {
        this.certStore = certStore;
    }

    public KcSigner getSigner() {
        return this.signer;
    }

    public void setSigner(KcSigner signer) {
        this.signer = signer;
    }

    public Pkcs7SignBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(Pkcs7SignBuilder builder) {
        this.builder = builder;
    }

    public byte[] sign(byte[] oriData, boolean isDetach, String digestAlg) throws KcException {
        if (!(this.certStore instanceof KcKeyStore)) {
            throw new KcException(100151, "p7 sign: no key");
        }
        KcKeyStore keyStore = (KcKeyStore)this.certStore;
        if (null == this.builder) {
            this.builder = Pkcs7SignBuilderFactory.createBuilderByPrivateKey(keyStore.getPrivateKey());
        }
        if (null == this.signer) {
            this.signer = KcSignerFactory.createSignerByPrivateKey(keyStore.getPrivateKey());
        }
        if (null != digestAlg) {
            this.signer.setDigestAlg(digestAlg);
        }
        byte[] signData = this.signer.sign(oriData);
        byte[] p7Sign = null;
        p7Sign = isDetach ? this.builder.buildDetach(oriData, signData, this.certStore.getCert(), this.signer) : this.builder.buildAttach(oriData, signData, this.certStore.getCert(), this.signer);
        return p7Sign;
    }

    public byte[] sign(byte[] oriData, boolean isDetach) throws KcException {
        return this.sign(oriData, isDetach, null);
    }

    public byte[] sign(byte[] oriData, String digestAlg) throws KcException {
        return this.sign(oriData, false, digestAlg);
    }

    public byte[] sign(byte[] oriData) throws KcException {
        return this.sign(oriData, false);
    }

    public byte[] detachSign(byte[] oriData) throws KcException {
        return this.sign(oriData, true);
    }

    public byte[] detachSign(byte[] oriData, String digestAlg) throws KcException {
        return this.sign(oriData, true, digestAlg);
    }

    public boolean verify(byte[] signData) throws KcException {
        return this.verify(null, signData);
    }

    public boolean verify(byte[] oriData, byte[] signData) throws KcException {
        Pkcs7SignParser parser = new Pkcs7SignParser();
        parser.parse(signData);
        byte[] origin = parser.getOriData();
        if (null == origin) {
            origin = oriData;
        }
        if (null == origin) {
            throw new KcException(100162, "verify p7 sign: ori data empty");
        }
        if (StringUtil.isNotEmpty(oriData) && StringUtil.isNotEmpty(parser.getOriData()) && !Arrays.areEqual(parser.getOriData(), oriData)) {
            throw new KcException(100161, "verify p7 sign: ori data unmatched");
        }
        List<Pkcs7SignParser.Pkcs7SignInfo> signInfos = parser.getSignInfos();
        int nsize = signInfos.size();
        Pkcs7SignParser.Pkcs7SignInfo signInfo = null;
        KcSigner signer = this.signer;
        for (int i = 0; i < nsize; ++i) {
            signInfo = signInfos.get(i);
            if (null == signer) {
                signer = KcSignerFactory.createSignerByCert(signInfo.signCert);
            }
            if (null != signInfo.digestAid) {
                signer.setDigestAlgId(signInfo.digestAid);
            }
            if (StringUtil.isEmpty(signInfo.authAttrData)) {
                if (signer.verify(origin, signInfo.signData)) continue;
                return false;
            }
            byte[] authAttrData = signInfo.getAuthAttrData();
            authAttrData[0] = 49;
            if (!signer.verify(authAttrData, signInfo.signData)) {
                return false;
            }
            byte[] oriDigestData = this.getAuthAttrMessageDigest(authAttrData);
            if (null == oriDigestData) {
                return false;
            }
            DefaultAlgorithmNameFinder finder = new DefaultAlgorithmNameFinder();
            String digestAlg = finder.getAlgorithmName(signInfo.digestAid);
            Digest digest = KcDigestUtil.findDigest(digestAlg);
            digest.update(oriData, 0, oriData.length);
            byte[] hash = new byte[digest.getDigestSize()];
            digest.doFinal(hash, 0);
            if (Arrays.areEqual(oriDigestData, hash)) continue;
            return false;
        }
        return true;
    }

    public static void dump(byte[] signData) throws KcException {
        Pkcs7SignParser parser = new Pkcs7SignParser();
        parser.parse(signData);
    }

    public byte[] signAttrs(byte[] oriData, boolean isDetach, String digestAlg) throws KcException {
        if (null == digestAlg) {
            throw new KcException(100151, "p7 sign: no key");
        }
        Digest digest = KcDigestUtil.findDigest(digestAlg);
        digest.update(oriData, 0, oriData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        Attributes attributes = this.createSignedAttrs(hash);
        return this.signAttrs(oriData, isDetach, digestAlg, attributes);
    }

    public byte[] signAttrs(byte[] oriData, boolean isDetach, String digestAlg, Attributes attributes) throws KcException {
        if (!(this.certStore instanceof KcKeyStore)) {
            throw new KcException(100151, "p7 sign: no key");
        }
        KcKeyStore keyStore = (KcKeyStore)this.certStore;
        if (null == this.builder) {
            this.builder = Pkcs7SignBuilderFactory.createBuilderByPrivateKey(keyStore.getPrivateKey());
        }
        if (null == this.signer) {
            this.signer = KcSignerFactory.createSignerByPrivateKey(keyStore.getPrivateKey());
        }
        if (null != digestAlg) {
            this.signer.setDigestAlg(digestAlg);
        }
        ASN1Set authAttrs = ASN1Set.getInstance(attributes);
        byte[] authAttrsData = null;
        try {
            authAttrsData = authAttrs.getEncoded();
        }
        catch (IOException e) {
            throw new KcException(100004, "p7 sign: encoded error");
        }
        byte[] signData = this.signer.sign(authAttrsData);
        X509CertificateHolder cert = this.certStore.getCert();
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(cert.getIssuer(), cert.getSerialNumber());
        SignerInfo sinfo = new SignerInfo(new SignerIdentifier(isn), this.signer.getDigestAlgId(), attributes, this.signer.getEncryptAlgId(), (ASN1OctetString)new DEROctetString(signData), null);
        byte[] p7Sign = null;
        p7Sign = isDetach ? this.builder.build(oriData, this.certStore.getCert(), this.signer, sinfo, true) : this.builder.build(oriData, this.certStore.getCert(), this.signer, sinfo, false);
        return p7Sign;
    }

    private byte[] getAuthAttrMessageDigest(byte[] authAttrData) {
        ASN1Set authAttrs = ASN1Set.getInstance(authAttrData);
        if (null != authAttrs) {
            int nsize = authAttrs.size();
            Attribute attr = null;
            for (int i = 0; i < nsize; ++i) {
                attr = Attribute.getInstance(authAttrs.getObjectAt(i));
                if (!PKCSObjectIdentifiers.pkcs_9_at_messageDigest.equals(attr.getAttrType())) continue;
                return ASN1OctetString.getInstance(attr.getAttributeValues()[0]).getOctets();
            }
        }
        return null;
    }

    private Attributes createSignedAttrs(byte[] digestData) {
        Attribute contenType = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, new BERSet(PKCSObjectIdentifiers.data));
        Attribute signingTime = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, new BERSet(new ASN1UTCTime(new Date())));
        Attribute messageDigest = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, new BERSet(new DEROctetString(digestData)));
        ASN1EncodableVector seqs = new ASN1EncodableVector();
        BERSequence contentEncryptionAlgorithms = new BERSequence(PKCSObjectIdentifiers.des_EDE3_CBC);
        ASN1EncodableVector digestAlg = new ASN1EncodableVector();
        digestAlg.add(PKCSObjectIdentifiers.RC2_CBC);
        digestAlg.add(new ASN1Integer(128L));
        BERSequence digestAlgorithms = new BERSequence(digestAlg);
        ASN1EncodableVector asymmetricEncryptionAlg = new ASN1EncodableVector();
        asymmetricEncryptionAlg.add(PKCSObjectIdentifiers.RC2_CBC);
        asymmetricEncryptionAlg.add(new ASN1Integer(64L));
        BERSequence asymmetricEncryptionAlgorithms = new BERSequence(asymmetricEncryptionAlg);
        BERSequence signatureAlgorithms = new BERSequence(OIWObjectIdentifiers.desCBC);
        ASN1EncodableVector signedAttr = new ASN1EncodableVector();
        signedAttr.add(PKCSObjectIdentifiers.RC2_CBC);
        signedAttr.add(new ASN1Integer(40L));
        BERSequence signedAttributes = new BERSequence(signedAttr);
        seqs.add(contentEncryptionAlgorithms);
        seqs.add(digestAlgorithms);
        seqs.add(asymmetricEncryptionAlgorithms);
        seqs.add(signatureAlgorithms);
        seqs.add(signedAttributes);
        Attribute smimeCapabilities = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_smimeCapabilities, new BERSet(new BERSequence(seqs)));
        ASN1EncodableVector attributes = new ASN1EncodableVector();
        attributes.add(contenType);
        attributes.add(signingTime);
        attributes.add(messageDigest);
        attributes.add(smimeCapabilities);
        return new Attributes(attributes);
    }

    public static void main(String[] args) throws KcException {
    }
}

