/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1InputStream;
import com.koalii.kgsp.bc.asn1.DEROctetString;
import com.koalii.kgsp.bc.asn1.cms.ContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EncryptedContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EnvelopedData;
import com.koalii.kgsp.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.kgsp.bc.asn1.cms.KeyTransRecipientInfo;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.crypto.KcSM4;
import com.koalii.kgsp.core.util.SM2PKCSObjectIdentifiers;
import java.math.BigInteger;

public class GMPkcs7EnvelopParser {
    public static void main(String[] args) throws Exception {
        GMPkcs7EnvelopParser pep = new GMPkcs7EnvelopParser();
        String b64Evpdata = "MIIBsAYJKoZIhvcNAQcDoIIBoTCCAZ0CAQAxggFhMIIBXQIBADBHMDMxCzAJBgNVBAYTAkNOMREwDwYDVQQKDAhVbmlUcnVzdDERMA8GA1UEAwwIU0hFQ0EgRzICEEyeGNs7Tbz+cEmvR+3y5rwwCwYJKoZIhvcNAQEBBIIBAEnfB6dRyjKy8wP4bLQK5bfBRsd9wo+MRiGXPVI4Rq/r5Z4Fr65J1bgdoFZaVMhnTp1IXTEM0XlQtOv3Zy8K/9Qjef3TqzQtc3WiK0qFTphFk4tgpSijq8bUyMbUe6Uj4k1gVcMN84y7xKzg8KSK+9XQmFwAqz35MBzyJYlRWeCarT4gTzw+KtjbtHwIcty6KbaxF1Ewn5iZSZvh5ypHGfy9BDXG4cO6eps1w/wNAFst1xwqxGM257b1v+71B/iIfHBDd2Zi0OfR+37zDOBBcgxc3ugxM8/I9zccF8Zdk8P9CoILKQkf32vCKs6cyCXVA3RmjrsyRLqVj6dFYZK7tukwMwYJKoZIhvcNAQcBMBQGCCqGSIb3DQMHBAiZbcH7WP+BkIAQ/AtrwxsZzz5gfZHFYPMkAg==";
        String b64Key = "bcGXEAtPech51kZF7yxhhYaigMg4/bV/";
        System.out.println(GMPkcs7EnvelopParser.isGMPkcs7Envelop(Base64.decode(b64Evpdata)));
    }

    public static boolean isGMPkcs7Envelop(byte[] evpdata) throws Exception {
        if (null == evpdata) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new Exception(exp);
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (null == edata) {
            throw new Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        String evpId = recinfo.getKeyEncryptionAlgorithm().getAlgorithm().getId();
        String rsaId = SM2PKCSObjectIdentifiers.sm2Encryption.getId();
        return evpId.equals(rsaId);
    }

    public byte[] parseEnvelopEncryptKey(byte[] evpdata) throws Exception {
        if (null == evpdata) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new Exception(exp);
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (null == edata) {
            throw new Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        return recinfo.getEncryptedKey().getOctets();
    }

    public BigInteger parseEncryptCertSn(byte[] evpdata) throws Exception {
        if (null == evpdata) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new Exception(exp);
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (null == edata) {
            throw new Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        IssuerAndSerialNumber isn = IssuerAndSerialNumber.getInstance(recinfo.getRecipientIdentifier().getId());
        return isn.getSerialNumber().getValue();
    }

    public byte[] parseEnvelop(byte[] evpdata, byte[] key) throws Exception {
        if (null == evpdata) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new Exception(exp);
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (null == edata) {
            throw new Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        EncryptedContentInfo einfo = edata.getEncryptedContentInfo();
        byte[] oriData = null;
        try {
            KcSM4 des = new KcSM4("CBC");
            byte[] iv = ((DEROctetString)einfo.getContentEncryptionAlgorithm().getParameters()).getOctets();
            oriData = des.decrypt(einfo.getEncryptedContent().getOctets(), key, iv);
        }
        catch (Exception exp) {
            throw new Exception(exp);
        }
        return oriData;
    }
}

