/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.pkcs.CertificationRequestInfo;
import com.koalii.kgsp.bc.asn1.x500.X500Name;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.util.SubjectPublicKeyInfoFactory;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.pkcs.Pkcs10Builder;

public class GMPkcs10Builder
extends Pkcs10Builder {
    public GMPkcs10Builder(KcAsymmetricKeyPair keyPair) {
        super(keyPair);
    }

    @Override
    public byte[] generateTbs(String subject, AsymmetricKeyParameter publicKey) throws KcException {
        try {
            X500Name subjectName = new X500Name(subject);
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey);
            AlgorithmIdentifier ai = new AlgorithmIdentifier(spki.getAlgorithm().getAlgorithm(), new ASN1ObjectIdentifier("1.2.156.10197.1.301"));
            SubjectPublicKeyInfo nspkinfo = new SubjectPublicKeyInfo(ai, spki.getPublicKeyData().getBytes());
            CertificationRequestInfo tbsinfo = new CertificationRequestInfo(subjectName, nspkinfo, this.getAttributes());
            return tbsinfo.getEncoded();
        }
        catch (Exception e) {
            throw new KcException(100183, "create gm p10 tbs failed: " + subject);
        }
    }
}

