/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.io;

import com.koalii.kgsp.bc.crypto.Digest;
import com.koalii.kgsp.bc.crypto.io.DigestInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class KcDigestInputStream
extends DigestInputStream {
    private ByteArrayOutputStream baos;

    public KcDigestInputStream(InputStream stream, Digest digest) {
        super(stream, digest);
    }

    public KcDigestInputStream(InputStream stream) {
        this(stream, null);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = 0;
        if (this.digest == null) {
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream();
            }
            n = this.in.read(b, off, len);
            this.baos.write(b, off, n);
        } else {
            if (this.baos != null) {
                byte[] cachedData = this.baos.toByteArray();
                this.digest.update(cachedData, 0, cachedData.length);
                this.baos.close();
                this.baos = null;
            }
            n = super.read(b, off, len);
        }
        return n;
    }

    public void setDigest(Digest digest) {
        this.digest = digest;
    }
}

