/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.crypto.KeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.engines.DESedeEngine;
import com.koalii.kgsp.bc.crypto.generators.DESedeKeyGenerator;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.crypto.KcBlockCipher;
import java.security.SecureRandom;
import java.util.Arrays;

public class KcTripleDES
extends KcBlockCipher {
    public KcTripleDES() {
        super(new DESedeEngine());
    }

    public KcTripleDES(String mode) {
        super(new DESedeEngine(), mode);
    }

    @Override
    public byte[] generateKey(byte[] seed) {
        SecureRandom sr = new SecureRandom();
        if (null != seed) {
            sr.setSeed(seed);
        }
        DESedeKeyGenerator keyGen = new DESedeKeyGenerator();
        keyGen.init(new KeyGenerationParameters(sr, 192));
        return keyGen.generateKey();
    }

    public static void main(String[] args) throws Exception {
        String s = "1";
        KcTripleDES des = new KcTripleDES("CBC");
        des.setPaddingMode("PADDING_ZERO");
        byte[] key = des.generateKey();
        byte[] iv = des.generateIV();
        System.out.println("key length==> " + key.length);
        System.out.println("key base64==> " + new String(Base64.encode(key)));
        System.out.println("key:" + Arrays.toString(key));
        System.out.println("iv length==> " + iv.length);
        System.out.println("iv base64==> " + new String(Base64.encode(iv)));
        System.out.println("iv:" + Arrays.toString(iv));
        byte[] secData = des.encrypt(s.getBytes(), key);
        System.out.println(des.getAlgorithmName() + ":" + secData.length);
        System.out.println("secData:" + new String(Base64.encode(secData)));
        byte[] oriData = des.decrypt(secData, key);
        System.out.println(new String(oriData));
        des.setAlgMode("CBC");
        secData = des.encrypt(s.getBytes(), key, iv);
        System.out.println(des.getAlgorithmName() + ":" + secData.length);
        System.out.println("secData ==> " + new String(Base64.encode(secData)));
        oriData = des.decrypt(secData, key, iv);
        System.out.println(new String(oriData));
    }
}

