/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.operator.DefaultAlgorithmNameFinder;
import com.koalii.kgsp.bc.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.koalii.kgsp.bc.operator.DefaultSignatureAlgorithmIdentifierFinder;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.exception.KcException;

public abstract class KcSigner {
    protected X509CertificateHolder signerCert;
    protected AsymmetricKeyParameter signerPublicKey;
    protected AsymmetricKeyParameter signerPrivateKey;
    protected AlgorithmIdentifier digestAlgId;

    public KcSigner() {
    }

    public KcSigner(KcAsymmetricKeyPair keyPair) {
        this.setSignerKeyPair(keyPair);
    }

    public KcSigner(AsymmetricKeyParameter publicKey, AsymmetricKeyParameter privateKey) {
        this.setSignerKeyPair(publicKey, privateKey);
    }

    public KcSigner(KcKeyStore store) {
        this.setSignerKeyStore(store);
    }

    public KcSigner(KcCertStore store) {
        this.setSignerCertStore(store);
    }

    public void setSignerKeyStore(KcKeyStore store) {
        this.signerCert = store.getCert();
        this.signerPublicKey = store.getPublicKey();
        this.signerPrivateKey = store.getPrivateKey();
    }

    public void setSignerCertStore(KcCertStore store) {
        this.signerCert = store.getCert();
        this.signerPublicKey = store.getPublicKey();
        this.signerPrivateKey = null;
    }

    public void setSignerKeyPair(AsymmetricKeyParameter signerPublicKey, AsymmetricKeyParameter signerPrivateKey) {
        this.signerPublicKey = signerPublicKey;
        this.signerPrivateKey = signerPrivateKey;
    }

    public void setSignerKeyPair(KcAsymmetricKeyPair keyPair) {
        if (null == keyPair) {
            return;
        }
        this.signerPublicKey = keyPair.getPublicKey();
        this.signerPrivateKey = keyPair.getPrivateKey();
    }

    public X509CertificateHolder getSignerCert() {
        return this.signerCert;
    }

    public AsymmetricKeyParameter getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public AsymmetricKeyParameter getSignerPrivateKey() {
        return this.signerPrivateKey;
    }

    public void setDigestAlg(String alg) {
        DefaultDigestAlgorithmIdentifierFinder finder = new DefaultDigestAlgorithmIdentifierFinder();
        this.digestAlgId = finder.find(alg);
    }

    public String getDigestAlg() {
        if (null == this.digestAlgId) {
            return "";
        }
        DefaultAlgorithmNameFinder finder = new DefaultAlgorithmNameFinder();
        return finder.getAlgorithmName(this.digestAlgId);
    }

    public void setDigestAlgId(AlgorithmIdentifier digestAlgId) {
        this.digestAlgId = digestAlgId;
    }

    public AlgorithmIdentifier getDigestAlgId() {
        return this.digestAlgId;
    }

    public AlgorithmIdentifier getSignAlgId() {
        DefaultSignatureAlgorithmIdentifierFinder finder = new DefaultSignatureAlgorithmIdentifierFinder();
        return finder.find(this.getSignAlg());
    }

    public abstract String getSignAlg();

    public abstract AlgorithmIdentifier getEncryptAlgId();

    public abstract String getEncryptAlg();

    public abstract byte[] sign(byte[] var1) throws KcException;

    public abstract boolean verify(byte[] var1, byte[] var2) throws KcException;
}

