/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.crypto.engines.SM4Engine;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.crypto.KcBlockCipher;

public class KcSM4
extends KcBlockCipher {
    public KcSM4() {
        super(new SM4Engine());
    }

    public KcSM4(String mode) {
        super(new SM4Engine(), mode);
    }

    @Override
    public byte[] generateKey(byte[] seed) {
        return this.generateKey(seed, 128);
    }

    public static void main(String[] args) throws Exception {
        String s = "Hello,world!";
        KcSM4 sm4 = new KcSM4("ECB");
        byte[] key = sm4.generateKey();
        byte[] iv = sm4.generateIV();
        byte[] secData = sm4.encrypt(s.getBytes(), key);
        System.out.println(sm4.getAlgorithmName() + ":" + secData.length);
        System.out.println(Hex.toHexString(secData));
        byte[] oriData = sm4.decrypt(secData, key);
        System.out.println(new String(oriData));
        sm4.setAlgMode("CBC");
        secData = sm4.encrypt(s.getBytes(), key, iv);
        System.out.println(sm4.getAlgorithmName() + ":" + secData.length);
        System.out.println(Hex.toHexString(secData));
        oriData = sm4.decrypt(secData, key, iv);
        System.out.println(new String(oriData));
    }
}

