/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.asn1.gm.GMObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ECPrivateKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ECPublicKeyParameters;
import com.koalii.kgsp.bc.crypto.signers.SM2Signer;
import com.koalii.kgsp.bc.operator.DefaultAlgorithmNameFinder;
import com.koalii.kgsp.bc.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.crypto.KcSigner;
import com.koalii.kgsp.core.exception.KcException;

public class KcSM2Signer
extends KcSigner {
    private static String DEFAULT_DIGEST_ALG = "SM3";

    public KcSM2Signer() {
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcSM2Signer(KcAsymmetricKeyPair keyPair) {
        super(keyPair);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcSM2Signer(AsymmetricKeyParameter publicKey, AsymmetricKeyParameter privateKey) {
        super(publicKey, privateKey);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcSM2Signer(KcKeyStore store) {
        super(store);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcSM2Signer(KcCertStore store) {
        super(store);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    @Override
    public byte[] sign(byte[] oriData) throws KcException {
        if (null == this.signerPrivateKey) {
            throw new KcException(100120, "sm2 sign: private key empty");
        }
        if (!(this.signerPrivateKey instanceof ECPrivateKeyParameters)) {
            throw new KcException(100121, "sm2 sign: private key alg error");
        }
        SM2Signer signer = new SM2Signer();
        signer.init(true, this.signerPrivateKey);
        signer.update(oriData, 0, oriData.length);
        try {
            return signer.generateSignature();
        }
        catch (Exception e) {
            throw new KcException(100147, "sm2 sign failed", e);
        }
    }

    @Override
    public boolean verify(byte[] oriData, byte[] signData) throws KcException {
        if (null == this.signerPublicKey) {
            throw new KcException(100125, "sm2 verify: public key empty");
        }
        if (!(this.signerPublicKey instanceof ECPublicKeyParameters)) {
            throw new KcException(100126, "sm2 verify: public key alg error");
        }
        SM2Signer signer = new SM2Signer();
        signer.init(false, this.signerPublicKey);
        signer.update(oriData, 0, oriData.length);
        return signer.verifySignature(signData);
    }

    @Override
    public void setDigestAlg(String alg) {
        if (alg.equalsIgnoreCase("SM3")) {
            this.digestAlgId = new AlgorithmIdentifier(GMObjectIdentifiers.sm3);
        }
        DefaultDigestAlgorithmIdentifierFinder finder = new DefaultDigestAlgorithmIdentifierFinder();
        this.digestAlgId = finder.find(alg);
    }

    @Override
    public String getDigestAlg() {
        if (null == this.digestAlgId) {
            return "";
        }
        if (GMObjectIdentifiers.sm3.equals(this.digestAlgId.getAlgorithm())) {
            return "SM3";
        }
        DefaultAlgorithmNameFinder finder = new DefaultAlgorithmNameFinder();
        return finder.getAlgorithmName(this.digestAlgId);
    }

    @Override
    public String getSignAlg() {
        return this.getDigestAlg() + "WITHSM2";
    }

    @Override
    public AlgorithmIdentifier getEncryptAlgId() {
        return new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign);
    }

    @Override
    public String getEncryptAlg() {
        return "SM2";
    }

    public static void main(String[] args) {
    }
}

