/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.exception.KcException;

public abstract class KcEncryptor {
    protected X509CertificateHolder encCert;
    protected AsymmetricKeyParameter encPublicKey;
    protected AsymmetricKeyParameter encPrivateKey;

    public KcEncryptor() {
    }

    public KcEncryptor(KcAsymmetricKeyPair keyPair) {
        this.setEncKeyPair(keyPair);
    }

    public KcEncryptor(AsymmetricKeyParameter publicKey, AsymmetricKeyParameter privateKey) {
        this.setEncKeyPair(publicKey, privateKey);
    }

    public KcEncryptor(KcKeyStore store) {
        this.setEncKeyStore(store);
    }

    public KcEncryptor(KcCertStore store) {
        this.setEncCertStore(store);
    }

    public void setEncKeyStore(KcKeyStore store) {
        this.encCert = store.getCert();
        this.encPublicKey = store.getPublicKey();
        this.encPrivateKey = store.getPrivateKey();
    }

    public void setEncCertStore(KcCertStore store) {
        this.encCert = store.getCert();
        this.encPublicKey = store.getPublicKey();
        this.encPrivateKey = null;
    }

    public void setEncKeyPair(AsymmetricKeyParameter signerPublicKey, AsymmetricKeyParameter signerPrivateKey) {
        this.encPublicKey = signerPublicKey;
        this.encPrivateKey = signerPrivateKey;
    }

    public void setEncKeyPair(KcAsymmetricKeyPair keyPair) {
        if (null == keyPair) {
            return;
        }
        this.encPublicKey = keyPair.getPublicKey();
        this.encPrivateKey = keyPair.getPrivateKey();
    }

    public X509CertificateHolder getEncCert() {
        return this.encCert;
    }

    public AsymmetricKeyParameter getEncPublicKey() {
        return this.encPublicKey;
    }

    public AsymmetricKeyParameter getEncPrivateKey() {
        return this.encPrivateKey;
    }

    public abstract byte[] encrypt(byte[] var1) throws KcException;

    public abstract byte[] decrypt(byte[] var1) throws KcException;
}

